/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.block;

import net.danygames2014.nyalib.block.FenceBlockTemplate;
import net.danygames2014.nyalib.block.FenceGateBlockTemplate;
import net.danygames2014.nyalib.block.TemplateBlockRegistry;
import net.danygames2014.nyalib.block.WallBlockTemplate;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_229;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class PaneBlockTemplate
extends TemplateBlock {
    public PaneBlockTemplate(Identifier identifier, class_17 baseBlock, class_15 material, Identifier texture, Identifier edgeTexture) {
        super(identifier, material);
        if (texture != null) {
            TemplateBlockRegistry.registerPane(identifier, texture, edgeTexture);
        }
    }

    public PaneBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture, Identifier edgeTexture) {
        this(identifier, baseBlock, baseBlock.field_1900, texture, edgeTexture);
    }

    public PaneBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        this(identifier, baseBlock, texture, texture);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{Properties.NORTH, Properties.SOUTH, Properties.EAST, Properties.WEST});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)super.getPlacementState(context).with((Property)Properties.EAST, (Comparable)Boolean.valueOf(false))).with((Property)Properties.WEST, (Comparable)Boolean.valueOf(false))).with((Property)Properties.NORTH, (Comparable)Boolean.valueOf(false))).with((Property)Properties.SOUTH, (Comparable)Boolean.valueOf(false));
    }

    public void method_1611(class_18 world, int x, int y, int z) {
        this.updateConnections(world, x, y, z);
        super.method_1611(world, x, y, z);
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        this.updateConnections(world, x, y, z);
        super.method_1609(world, x, y, z, id);
    }

    public void updateConnections(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        state = this.getPaneState(world, x, y, z, state, Direction.EAST, Properties.EAST);
        state = this.getPaneState(world, x, y, z, state, Direction.WEST, Properties.WEST);
        state = this.getPaneState(world, x, y, z, state, Direction.NORTH, Properties.NORTH);
        state = this.getPaneState(world, x, y, z, state, Direction.SOUTH, Properties.SOUTH);
        world.setBlockStateWithNotify(x, y, z, state);
    }

    public boolean canConnectTo(BlockState state) {
        if (state.isAir()) {
            return false;
        }
        class_17 block = state.getBlock();
        if (block instanceof WallBlockTemplate || block instanceof FenceBlockTemplate || block instanceof FenceGateBlockTemplate || block instanceof class_229 || block instanceof PaneBlockTemplate) {
            return true;
        }
        return state.getMaterial().method_897() && state.getBlock().method_1623();
    }

    private BlockState getPaneState(class_18 world, int x, int y, int z, BlockState state, Direction side, BooleanProperty property) {
        return (BlockState)state.with((Property)property, (Comparable)Boolean.valueOf(this.canConnectTo(world.getBlockState(x + side.getOffsetX(), y, z + side.getOffsetZ()))));
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }
}

