/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.block;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.HashMap;
import net.danygames2014.nyalib.block.JsonOverrideRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.modificationstation.stationapi.api.util.Identifier;

public class TemplateBlockRegistry {
    public static HashMap<Identifier, Identifier> stairs = new HashMap();
    public static HashMap<Identifier, Identifier> slabs = new HashMap();
    public static HashMap<Identifier, Identifier> fences = new HashMap();
    public static HashMap<Identifier, Identifier> fenceGates = new HashMap();
    public static HashMap<Identifier, Identifier> buttons = new HashMap();
    public static HashMap<Identifier, Identifier> walls = new HashMap();
    public static HashMap<Identifier, Identifier> pressurePlates = new HashMap();
    public static HashMap<Identifier, Identifier> ladders = new HashMap();
    public static HashMap<Identifier, Identifier> doors = new HashMap();
    public static HashMap<Identifier, Identifier> trapdoors = new HashMap();
    public static HashMap<Identifier, Identifier> flowerPots = new HashMap();
    public static HashMap<Identifier, Pair<Identifier, Identifier>> panes = new HashMap();
    public static HashMap<Identifier, Identifier> carpets = new HashMap();
    public static HashMap<Identifier, Identifier> signs = new HashMap();
    public static HashMap<Identifier, Identifier> torches = new HashMap();
    public static HashMap<Identifier, Pair<Identifier, Identifier>> rotateableBlockTemplate = new HashMap();
    public static final String itemJson = "{\n  \"parent\": \"PATH\"\n}";
    public static final String stairsJson = "{\n  \"parent\": \"nyalib-base:block/stairs\",\n  \"textures\": {\n  }\n}";
    public static final String stairsStateJson = "{\n  \"variants\": {\n    \"facing=north\": {\n      \"model\": \"PATH\"\n    },\n    \"facing=east\": {\n      \"model\": \"PATH\",\n      \"y\": 90\n    },\n    \"facing=south\": {\n      \"model\": \"PATH\",\n      \"y\": 180\n    },\n    \"facing=west\": {\n      \"model\": \"PATH\",\n      \"y\": 270\n    }\n  }\n}";
    public static final String slabJson = "{\n  \"parent\": \"nyalib-base:block/slab\",\n  \"textures\": {\n  }\n}";
    public static final String doubleSlabJson = "{\n  \"parent\": \"minecraft:block/cube_all\",\n  \"textures\": {\n  }\n}";
    public static final String slabStateJson = "{\n  \"variants\": {\n    \"slab_type=bottom\": {\n      \"model\": \"SINGLE\"\n    },\n\n    \"slab_type=top\": {\n      \"model\": \"SINGLE\",\n      \"x\": 180\n    },\n\n    \"slab_type=double\": {\n      \"model\": \"DOUBLE\"\n    }\n  }\n}";
    public static final String fenceInventoryJson = "{\n  \"parent\": \"nyalib-base:block/fence_inventory\",\n  \"textures\": {\n  }\n}\n";
    public static final String fenceSideJson = "{\n  \"parent\": \"nyalib-base:block/fence_side\",\n  \"textures\": {\n  }\n}";
    public static final String fencePostJson = "{\n  \"parent\": \"nyalib-base:block/fence_post\",\n  \"textures\": {\n  }\n}";
    public static final String fenceStateJson = "{\n  \"multipart\": [\n    {\n      \"apply\": {\n        \"model\": \"POST\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 270\n      },\n      \"when\": {\n        \"north\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 0\n      },\n      \"when\": {\n        \"east\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 90\n      },\n      \"when\": {\n        \"south\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 180\n      },\n      \"when\": {\n        \"west\": \"true\"\n      }\n    }\n  ]\n}";
    public static final String fenceGateOpenJson = "{\n  \"parent\": \"nyalib-base:block/fence_gate_open\",\n  \"textures\": {\n  }\n}";
    public static final String fenceGateCloseJson = "{\n  \"parent\": \"nyalib-base:block/fence_gate_closed\",\n  \"textures\": {\n  }\n}";
    public static final String fenceGateWallOpenJson = "{\n  \"parent\": \"nyalib-base:block/fence_gate_wall_open\",\n  \"textures\": {\n  }\n}";
    public static final String fenceGateWallCloseJson = "{\n  \"parent\": \"nyalib-base:block/fence_gate_wall_closed\",\n  \"textures\": {\n  }\n}";
    public static final String fenceGateStateJson = "{\n  \"variants\": {\n    \"facing=south,open=false,in_wall=false\": {\n      \"model\": \"CLOSED\",\n      \"uvlock\": true,\n      \"y\": 270\n    },\n    \"facing=west,open=false,in_wall=false\": {\n      \"model\": \"CLOSED\",\n      \"uvlock\": true,\n      \"y\": 0\n    },\n    \"facing=north,open=false,in_wall=false\": {\n      \"model\": \"CLOSED\",\n      \"uvlock\": true,\n      \"y\": 90\n    },\n    \"facing=east,open=false,in_wall=false\": {\n      \"model\": \"CLOSED\",\n      \"uvlock\": true,\n      \"y\": 180\n    },\n    \"facing=south,open=true,in_wall=false\": {\n      \"model\": \"OPEN\",\n      \"uvlock\": true,\n      \"y\": 270\n    },\n    \"facing=west,open=true,in_wall=false\": {\n      \"model\": \"OPEN\",\n      \"uvlock\": true,\n      \"y\": 0\n    },\n    \"facing=north,open=true,in_wall=false\": {\n      \"model\": \"OPEN\",\n      \"uvlock\": true,\n      \"y\": 90\n    },\n    \"facing=east,open=true,in_wall=false\": {\n      \"model\": \"OPEN\",\n      \"uvlock\": true,\n      \"y\": 180\n    },\n\n    \"facing=south,open=false,in_wall=true\": {\n      \"model\": \"WALL_CL\",\n      \"uvlock\": true,\n      \"y\": 270\n    },\n    \"facing=west,open=false,in_wall=true\": {\n      \"model\": \"WALL_CL\",\n      \"uvlock\": true,\n      \"y\": 0\n    },\n    \"facing=north,open=false,in_wall=true\": {\n      \"model\": \"WALL_CL\",\n      \"uvlock\": true,\n      \"y\": 90\n    },\n    \"facing=east,open=false,in_wall=true\": {\n      \"model\": \"WALL_CL\",\n      \"uvlock\": true,\n      \"y\": 180\n    },\n    \"facing=south,open=true,in_wall=true\": {\n      \"model\": \"WALL_OP\",\n      \"uvlock\": true,\n      \"y\": 270\n    },\n    \"facing=west,open=true,in_wall=true\": {\n      \"model\": \"WALL_OP\",\n      \"uvlock\": true,\n      \"y\": 0\n    },\n    \"facing=north,open=true,in_wall=true\": {\n      \"model\": \"WALL_OP\",\n      \"uvlock\": true,\n      \"y\": 90\n    },\n    \"facing=east,open=true,in_wall=true\": {\n      \"model\": \"WALL_OP\",\n      \"uvlock\": true,\n      \"y\": 180\n    }\n  }\n}\n";
    public static final String buttonInventoryJson = "{\n  \"parent\": \"nyalib-base:block/button_inventory\",\n  \"textures\": {\n  }\n}";
    public static final String buttonJson = "{\n  \"parent\": \"nyalib-base:block/button\",\n  \"textures\": {\n  }\n}";
    public static final String buttonPressedJson = "{\n  \"parent\": \"nyalib-base:block/button_pressed\",\n  \"textures\": {\n  }\n}";
    public static final String buttonStateJson = "{\n  \"variants\": {\n    \"type=ceiling,facing=east,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"x\": 180,\n      \"y\": 180\n    },\n    \"type=ceiling,facing=east,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"x\": 180,\n      \"y\": 180\n    },\n    \"type=ceiling,facing=north,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"x\": 180,\n      \"y\": 90\n    },\n    \"type=ceiling,facing=north,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"x\": 180,\n      \"y\": 90\n    },\n    \"type=ceiling,facing=south,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"x\": 180,\n      \"y\": 270\n    },\n    \"type=ceiling,facing=south,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"x\": 180,\n      \"y\": 270\n    },\n    \"type=ceiling,facing=west,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"x\": 180,\n      \"y\": 0\n    },\n    \"type=ceiling,facing=west,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"x\": 180,\n      \"y\": 0\n    },\n    \"type=floor,facing=east,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"y\": 0\n    },\n    \"type=floor,facing=east,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"y\": 0\n    },\n    \"type=floor,facing=north,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"y\": 270\n    },\n    \"type=floor,facing=north,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"y\": 270\n    },\n    \"type=floor,facing=south,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"y\": 90\n    },\n    \"type=floor,facing=south,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"y\": 90\n    },\n    \"type=floor,facing=west,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"y\": 180\n    },\n    \"type=floor,facing=west,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"y\": 180\n    },\n    \"type=wall,facing=east,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 0\n    },\n    \"type=wall,facing=east,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 0\n    },\n    \"type=wall,facing=north,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 270\n    },\n    \"type=wall,facing=north,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 270\n    },\n    \"type=wall,facing=south,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 90\n    },\n    \"type=wall,facing=south,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 90\n    },\n    \"type=wall,facing=west,powered=false\": {\n      \"model\": \"NORMAL\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 180\n    },\n    \"type=wall,facing=west,powered=true\": {\n      \"model\": \"PRESSED\",\n      \"uvlock\": true,\n      \"x\": 90,\n      \"y\": 180\n    }\n  }\n}";
    public static final String wallInventoryJson = "{\n  \"parent\": \"nyalib-base:block/wall_inventory\",\n  \"textures\": {\n  }\n}";
    public static final String wallPostJson = "{\n  \"parent\": \"nyalib-base:block/wall_post\",\n  \"textures\": {\n  }\n}";
    public static final String wallSideJson = "{\n  \"parent\": \"nyalib-base:block/wall_side\",\n  \"textures\": {\n  }\n}";
    public static final String wallSideTallJson = "{\n  \"parent\": \"nyalib-base:block/wall_side_tall\",\n  \"textures\": {\n  }\n}";
    public static final String wallStateJson = "{\n  \"multipart\": [\n    {\n      \"apply\": {\n        \"model\": \"POST\"\n      },\n      \"when\": {\n        \"up\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 270\n      },\n      \"when\": {\n        \"north\": \"low\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 0\n      },\n      \"when\": {\n        \"east\": \"low\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 90\n      },\n      \"when\": {\n        \"south\": \"low\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"uvlock\": true,\n        \"y\": 180\n      },\n      \"when\": {\n        \"west\": \"low\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"TALL\",\n        \"uvlock\": true,\n        \"y\": 270\n      },\n      \"when\": {\n        \"north\": \"tall\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"TALL\",\n        \"uvlock\": true,\n        \"y\": 0\n      },\n      \"when\": {\n        \"east\": \"tall\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"TALL\",\n        \"uvlock\": true,\n        \"y\": 90\n      },\n      \"when\": {\n        \"south\": \"tall\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"TALL\",\n        \"uvlock\": true,\n        \"y\": 180\n      },\n      \"when\": {\n        \"west\": \"tall\"\n      }\n    }\n  ]\n}";
    public static final String paneInventoryJson = "{\n  \"parent\": \"minecraft:item/generated\",\n  \"textures\": {\n  }\n}";
    public static final String paneNosideJson = "{\n  \"parent\": \"nyalib-base:block/pane_noside\",\n  \"textures\": {\n  }\n}";
    public static final String paneNosideAltJson = "{\n  \"parent\": \"nyalib-base:block/pane_noside_alt\",\n  \"textures\": {\n  }\n}";
    public static final String panePostJson = "{\n  \"parent\": \"nyalib-base:block/pane_post\",\n  \"textures\": {\n  }\n}";
    public static final String paneSideJson = "{\n  \"parent\": \"nyalib-base:block/pane_side\",\n  \"textures\": {\n  }\n}";
    public static final String paneSideAltJson = "{\n  \"parent\": \"nyalib-base:block/pane_side_alt\",\n  \"textures\": {\n  }\n}";
    public static final String paneStateJson = "{\n  \"multipart\": [\n    {\n      \"apply\": {\n        \"model\": \"POST\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"y\": 270\n      },\n      \"when\": {\n        \"north\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"SIDE\",\n        \"y\": 0\n      },\n      \"when\": {\n        \"east\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"A_SID\",\n        \"y\": 270\n      },\n      \"when\": {\n        \"south\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"A_SID\",\n        \"y\": 0\n      },\n      \"when\": {\n        \"west\": \"true\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"N_SID\",\n        \"y\": 270\n      },\n      \"when\": {\n        \"north\": \"false\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"ANS_SID\",\n        \"y\": 270\n      },\n      \"when\": {\n        \"east\": \"false\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"ANS_SID\",\n        \"y\": 0\n      },\n      \"when\": {\n        \"south\": \"false\"\n      }\n    },\n    {\n      \"apply\": {\n        \"model\": \"N_SID\",\n        \"y\": 180\n      },\n      \"when\": {\n        \"west\": \"false\"\n      }\n    }\n  ]\n}";
    public static final String pressutePlateUpJson = "{\n  \"parent\": \"nyalib-base:block/pressure_plate_up\",\n  \"textures\": {\n  }\n}";
    public static final String pressutePlateDownJson = "{\n  \"parent\": \"nyalib-base:block/pressure_plate_down\",\n  \"textures\": {\n  }\n}";
    public static final String pressurePlateStateJson = "{\n  \"variants\": {\n    \"powered=false\": {\n      \"model\": \"UP\"\n    },\n    \"powered=true\": {\n      \"model\": \"DOWN\"\n    }\n  }\n}";

    public static void registerStairs(Identifier blockIdentifier, Identifier texture) {
        stairs.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(blockIdentifier, stairsJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(blockIdentifier, "all", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, itemJson.replace("PATH", TemplateBlockRegistry.getBlockModelPath(blockIdentifier)));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, stairsStateJson.replace("PATH", TemplateBlockRegistry.getBlockModelPath(blockIdentifier)));
    }

    public static void registerSlab(Identifier blockIdentifier, Identifier texture) {
        slabs.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_single", slabJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_single", "all", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_double", doubleSlabJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_double", "all", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, itemJson.replace("PATH", TemplateBlockRegistry.getBlockModelPath(blockIdentifier) + "_single"));
        String slabState = slabStateJson;
        slabState = slabState.replace("SINGLE", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_single"));
        slabState = slabState.replace("DOUBLE", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_double"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, slabState);
    }

    public static void registerFence(Identifier blockIdentifier, Identifier texture) {
        fences.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_post", fencePostJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_post", "side", texture);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_post", "end", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_side", fenceSideJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side", "texture", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, fenceInventoryJson);
        JsonOverrideRegistry.registerItemModelTextureOverride(blockIdentifier, "texture", texture);
        String fenceState = fenceStateJson;
        fenceState = fenceState.replace("POST", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_post"));
        fenceState = fenceState.replace("SIDE", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_side"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, fenceState);
    }

    public static void registerFenceGate(Identifier blockIdentifier, Identifier texture) {
        fenceGates.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_open", fenceGateOpenJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_open", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_closed", fenceGateCloseJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_closed", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_wall_open", fenceGateWallOpenJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_wall_open", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_wall_closed", fenceGateWallCloseJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_wall_closed", "texture", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, itemJson.replace("PATH", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_closed")));
        String fenceGateState = fenceGateStateJson;
        fenceGateState = fenceGateState.replace("OPEN", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_open"));
        fenceGateState = fenceGateState.replace("CLOSED", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_closed"));
        fenceGateState = fenceGateState.replace("WALL_OP", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_wall_open"));
        fenceGateState = fenceGateState.replace("WALL_CL", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_wall_closed"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, fenceGateState);
    }

    public static void registerButton(Identifier blockIdentifier, Identifier texture) {
        buttons.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_normal", buttonJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_normal", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_pressed", buttonPressedJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_pressed", "texture", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, buttonInventoryJson);
        JsonOverrideRegistry.registerItemModelTextureOverride(blockIdentifier, "texture", texture);
        String buttonState = buttonStateJson;
        buttonState = buttonState.replace("NORMAL", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_normal"));
        buttonState = buttonState.replace("PRESSED", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_pressed"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, buttonState);
    }

    public static void registerWall(Identifier blockIdentifier, Identifier texture) {
        walls.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_post", wallPostJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_post", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_side", wallSideJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_side_tall", wallSideTallJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side_tall", "texture", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, wallInventoryJson);
        JsonOverrideRegistry.registerItemModelTextureOverride(blockIdentifier, "texture", texture);
        String wallState = wallStateJson;
        wallState = wallState.replace("POST", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_post"));
        wallState = wallState.replace("SIDE", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_side"));
        wallState = wallState.replace("TALL", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_side_tall"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, wallState);
    }

    public static void registerPressurePlate(Identifier blockIdentifier, Identifier texture) {
        pressurePlates.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_up", pressutePlateUpJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_up", "texture", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_down", pressutePlateDownJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_down", "texture", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, pressutePlateUpJson);
        JsonOverrideRegistry.registerItemModelTextureOverride(blockIdentifier, "texture", texture);
        String pressurePlateState = pressurePlateStateJson;
        pressurePlateState = pressurePlateState.replace("UP", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_up"));
        pressurePlateState = pressurePlateState.replace("DOWN", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_down"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, pressurePlateState);
    }

    public static void registerLadder(Identifier blockIdentifier, Identifier texture) {
        ladders.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerDoor(Identifier blockIdentifier, Identifier texture) {
        doors.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerTrapdoor(Identifier blockIdentifier, Identifier texture) {
        trapdoors.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerFlowerPot(Identifier blockIdentifier, Identifier texture) {
        flowerPots.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerPane(Identifier blockIdentifier, Identifier texture, Identifier edgeTexture) {
        panes.put(blockIdentifier, (Pair<Identifier, Identifier>)new ObjectObjectImmutablePair((Object)texture, (Object)edgeTexture));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_post", panePostJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_post", "pane", texture);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_post", "edge", edgeTexture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_side", paneSideJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side", "pane", texture);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side", "edge", edgeTexture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_side_alt", paneSideAltJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side_alt", "pane", texture);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_side_alt", "edge", edgeTexture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_noside", paneNosideJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_noside", "pane", texture);
        JsonOverrideRegistry.registerBlockModelOverride(String.valueOf(blockIdentifier) + "_noside_alt", paneNosideAltJson);
        JsonOverrideRegistry.registerBlockModelTextureOverride(String.valueOf(blockIdentifier) + "_noside_alt", "pane", texture);
        JsonOverrideRegistry.registerItemModelOverride(blockIdentifier, paneInventoryJson);
        JsonOverrideRegistry.registerItemModelTextureOverride(blockIdentifier, "layer0", texture);
        String paneState = paneStateJson;
        paneState = paneState.replace("POST", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_post"));
        paneState = paneState.replace("SIDE", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_side"));
        paneState = paneState.replace("A_SID", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_side_alt"));
        paneState = paneState.replace("N_SID", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_noside"));
        paneState = paneState.replace("ANS_SID", TemplateBlockRegistry.getBlockModelPath(String.valueOf(blockIdentifier) + "_noside_alt"));
        JsonOverrideRegistry.registerBlockstateOverride(blockIdentifier, paneState);
    }

    public static void registerCarpet(Identifier blockIdentifier, Identifier texture) {
        carpets.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerSign(Identifier blockIdentifier, Identifier texture) {
        signs.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerTorch(Identifier blockIdentifier, Identifier texture) {
        torches.put(blockIdentifier, texture);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static void registerRotateableBlock(Identifier blockIdentifier, Identifier endTexture, Identifier sideTexture) {
        rotateableBlockTemplate.put(blockIdentifier, (Pair<Identifier, Identifier>)new ObjectObjectImmutablePair((Object)endTexture, (Object)sideTexture));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
    }

    public static String getBlockModelPath(String blockIdentifier) {
        return TemplateBlockRegistry.getBlockModelPath(Identifier.of((String)blockIdentifier));
    }

    public static String getBlockModelPath(Identifier blockIdentifier) {
        return String.valueOf(blockIdentifier.namespace) + ":block/" + blockIdentifier.path;
    }
}

