/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.capability.entity;

import java.util.ArrayList;
import java.util.HashMap;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.capability.entity.EntityCapability;
import net.danygames2014.nyalib.capability.entity.EntityCapabilityProvider;
import net.danygames2014.nyalib.util.ClassUtil;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class EntityCapabilityRegistry {
    private static EntityCapabilityRegistry INSTANCE;
    private final HashMap<Identifier, CapabilityRegistryEntry> providerRegistry = new HashMap();
    private final HashMap<Class, CapabilityRegistryEntry> registryEntryClassLookup = new HashMap();

    public static EntityCapabilityRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EntityCapabilityRegistry();
        }
        return INSTANCE;
    }

    public static void registerCapabilityClass(Identifier identifier, Class<? extends EntityCapability> capabilityClass) {
        HashMap<Identifier, CapabilityRegistryEntry> r = EntityCapabilityRegistry.getInstance().providerRegistry;
        HashMap<Class, CapabilityRegistryEntry> lookup = EntityCapabilityRegistry.getInstance().registryEntryClassLookup;
        if (r.containsKey(identifier)) {
            NyaLib.LOGGER.warn("Attempted to register a entity capability class for " + String.valueOf(identifier) + " but a class has already been registered before.");
            NyaLib.LOGGER.warn("Already registered class:" + r.get((Object)identifier).capabilityClass.getName());
            NyaLib.LOGGER.warn("Class being registered:" + r.get((Object)identifier).capabilityClass.getName());
            return;
        }
        r.put(identifier, new CapabilityRegistryEntry(identifier, new ArrayList<EntityCapabilityProvider>(), capabilityClass));
        lookup.put(capabilityClass, r.get(identifier));
        NyaLib.LOGGER.info("Registered entity capability class " + capabilityClass.getName() + " for " + String.valueOf(identifier));
    }

    public static void register(Identifier identifier, EntityCapabilityProvider provider) {
        HashMap<Identifier, CapabilityRegistryEntry> r = EntityCapabilityRegistry.getInstance().providerRegistry;
        HashMap<Class, CapabilityRegistryEntry> lookup = EntityCapabilityRegistry.getInstance().registryEntryClassLookup;
        if (!r.containsKey(identifier)) {
            Class capabilityClass = ClassUtil.getGenericSuperclass((Object)provider, EntityCapability.class);
            if (EntityCapability.class.isAssignableFrom(capabilityClass)) {
                r.put(identifier, new CapabilityRegistryEntry(identifier, new ArrayList<EntityCapabilityProvider>(), capabilityClass));
                lookup.put(capabilityClass, r.get(identifier));
                NyaLib.LOGGER.warn("Provider for " + String.valueOf(identifier) + " is being registered, but no capability class has been registered. Using the " + String.valueOf(capabilityClass) + " class.");
            } else {
                NyaLib.LOGGER.error("Fallback lookup for entity capability class for " + String.valueOf(identifier) + " failed");
                return;
            }
        }
        r.get((Object)identifier).providers.add(provider);
        NyaLib.LOGGER.info("Provider " + provider.getClass().getName() + " registered for capability " + String.valueOf(identifier));
    }

    @Nullable
    public static <T extends EntityCapability> T getCapability(class_57 entity, Identifier identifier) {
        CapabilityRegistryEntry registryEntry = EntityCapabilityRegistry.getCapabilityRegistryEntry(identifier);
        if (registryEntry == null) {
            NyaLib.LOGGER.warn("Non-existent entity capability requested: " + String.valueOf(identifier));
            return null;
        }
        for (EntityCapabilityProvider provider : registryEntry.providers) {
            Object EntityCapability2 = provider.getCapability(entity);
            if (EntityCapability2 == null) continue;
            if (!registryEntry.capabilityClass.isAssignableFrom(EntityCapability2.getClass())) {
                NyaLib.LOGGER.warn("Provider " + EntityCapability2.getClass().getName() + " does not implement " + String.valueOf(EntityCapabilityRegistry.getCapabilityRegistryEntry(identifier)));
                continue;
            }
            return EntityCapability2;
        }
        return null;
    }

    @Nullable
    public static <T extends EntityCapability> T getCapability(class_57 entity, Class<T> capabilityClass) {
        CapabilityRegistryEntry registryEntry = EntityCapabilityRegistry.getCapabilityRegistryEntry(capabilityClass);
        if (registryEntry == null) {
            NyaLib.LOGGER.warn("Non-existent entity capability requested: " + capabilityClass.getName());
            return null;
        }
        for (EntityCapabilityProvider provider : registryEntry.providers) {
            Object EntityCapability2 = provider.getCapability(entity);
            if (EntityCapability2 == null) continue;
            if (!capabilityClass.isAssignableFrom(EntityCapability2.getClass())) {
                NyaLib.LOGGER.warn("Provider " + EntityCapability2.getClass().getName() + " does not implement " + String.valueOf(capabilityClass));
                continue;
            }
            return (T)((EntityCapability)capabilityClass.cast(EntityCapability2));
        }
        return null;
    }

    public static CapabilityRegistryEntry getCapabilityRegistryEntry(Identifier identifier) {
        return EntityCapabilityRegistry.getInstance().providerRegistry.get(identifier);
    }

    public static CapabilityRegistryEntry getCapabilityRegistryEntry(Class capabilityClass) {
        return EntityCapabilityRegistry.getInstance().registryEntryClassLookup.get(capabilityClass);
    }

    public static class CapabilityRegistryEntry {
        public Identifier identifier;
        public ArrayList<EntityCapabilityProvider> providers;
        public Class<? extends EntityCapability> capabilityClass;

        public CapabilityRegistryEntry(Identifier identifier, ArrayList<EntityCapabilityProvider> providers, Class<? extends EntityCapability> capabilityClass) {
            this.providers = providers;
            this.capabilityClass = capabilityClass;
        }
    }
}

