package net.danygames2014.nyalib.capability.item.itemhandler;

import net.danygames2014.nyalib.item.ItemHandlerItem;
import net.minecraft.class_124;
import net.minecraft.class_31;

public class ItemHandlerInterfaceItemCapability extends ItemHandlerItemCapability{
    private final ItemHandlerItem itemHandler;
    private final class_31 itemStack;

    public ItemHandlerInterfaceItemCapability(ItemHandlerItem itemHandler, class_31 itemStack) {
        this.itemHandler = itemHandler;
        this.itemStack = itemStack;
    }

    @Override
    public boolean canExtractItem() {
        return itemHandler.canExtractItem(itemStack);
    }

    @Override
    public class_31 extractItem(int slot, int amount) {
        return itemHandler.extractItem(itemStack, slot, amount);
    }

    @Override
    public class_31 extractItem() {
        return itemHandler.extractItem(itemStack);
    }

    @Override
    public class_31 extractItem(int amount) {
        return itemHandler.extractItem(itemStack, amount);
    }

    @Override
    public class_31 extractItem(class_124 item, int amount) {
        return itemHandler.extractItem(itemStack, item, amount);
    }

    @Override
    public boolean canInsertItem() {
        return itemHandler.canInsertItem(itemStack);
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot) {
        return itemHandler.insertItem(itemStack, stack, slot);
    }

    @Override
    public class_31 insertItem(class_31 stack) {
        return itemHandler.insertItem(itemStack, stack);
    }

    @Override
    public class_31 getItem(int slot) {
        return itemHandler.getItem(itemStack, slot);
    }

    @Override
    public boolean setItem(class_31 stack, int slot) {
        return itemHandler.setItem(itemStack, stack, slot);
    }

    @Override
    public int getItemSlots() {
        return itemHandler.getItemSlots(itemStack);
    }

    @Override
    public class_31[] getInventory() {
        return itemHandler.getInventory(itemStack);
    }
}
