/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.capability.block;

import java.util.ArrayList;
import java.util.HashMap;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.capability.block.BlockCapability;
import net.danygames2014.nyalib.capability.block.BlockCapabilityProvider;
import net.danygames2014.nyalib.util.ClassUtil;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class BlockCapabilityRegistry {
    private static BlockCapabilityRegistry INSTANCE;
    private final HashMap<Identifier, CapabilityRegistryEntry> providerRegistry = new HashMap();
    private final HashMap<Class, CapabilityRegistryEntry> registryEntryClassLookup = new HashMap();

    public static BlockCapabilityRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BlockCapabilityRegistry();
        }
        return INSTANCE;
    }

    public static void registerCapabilityClass(Identifier identifier, Class<? extends BlockCapability> capabilityClass) {
        HashMap<Identifier, CapabilityRegistryEntry> r = BlockCapabilityRegistry.getInstance().providerRegistry;
        HashMap<Class, CapabilityRegistryEntry> lookup = BlockCapabilityRegistry.getInstance().registryEntryClassLookup;
        if (r.containsKey(identifier)) {
            NyaLib.LOGGER.warn("Attempted to register a block capability class for " + String.valueOf(identifier) + " but a class has already been registered before.");
            NyaLib.LOGGER.warn("Already registered class:" + r.get((Object)identifier).capabilityClass.getName());
            NyaLib.LOGGER.warn("Class being registered:" + r.get((Object)identifier).capabilityClass.getName());
            return;
        }
        r.put(identifier, new CapabilityRegistryEntry(identifier, new ArrayList<BlockCapabilityProvider>(), capabilityClass));
        lookup.put(capabilityClass, r.get(identifier));
        NyaLib.LOGGER.info("Registered block capability class " + capabilityClass.getName() + " for " + String.valueOf(identifier));
    }

    public static void register(Identifier identifier, BlockCapabilityProvider provider) {
        HashMap<Identifier, CapabilityRegistryEntry> r = BlockCapabilityRegistry.getInstance().providerRegistry;
        HashMap<Class, CapabilityRegistryEntry> lookup = BlockCapabilityRegistry.getInstance().registryEntryClassLookup;
        if (!r.containsKey(identifier)) {
            Class capabilityClass = ClassUtil.getGenericSuperclass((Object)provider, BlockCapability.class);
            if (BlockCapability.class.isAssignableFrom(capabilityClass)) {
                r.put(identifier, new CapabilityRegistryEntry(identifier, new ArrayList<BlockCapabilityProvider>(), capabilityClass));
                lookup.put(capabilityClass, r.get(identifier));
                NyaLib.LOGGER.warn("Provider for " + String.valueOf(identifier) + " is being registered, but no capability class has been registered. Using the " + String.valueOf(capabilityClass) + " class.");
            } else {
                NyaLib.LOGGER.error("Fallback lookup for block capability class for " + String.valueOf(identifier) + " failed");
                return;
            }
        }
        r.get((Object)identifier).providers.add(provider);
        NyaLib.LOGGER.info("Provider " + provider.getClass().getName() + " registered for capability " + String.valueOf(identifier));
    }

    @Nullable
    public static <T extends BlockCapability> T getCapability(class_18 world, int x, int y, int z, Identifier identifier) {
        CapabilityRegistryEntry registryEntry = BlockCapabilityRegistry.getCapabilityRegistryEntry(identifier);
        if (registryEntry == null) {
            NyaLib.LOGGER.warn("Non-existent block capability requested: " + String.valueOf(identifier));
            return null;
        }
        for (BlockCapabilityProvider provider : registryEntry.providers) {
            Object blockCapability = provider.getCapability(world, x, y, z);
            if (blockCapability == null) continue;
            if (!registryEntry.capabilityClass.isAssignableFrom(blockCapability.getClass())) {
                NyaLib.LOGGER.warn("Provider " + blockCapability.getClass().getName() + " does not implement " + String.valueOf(BlockCapabilityRegistry.getCapabilityRegistryEntry(identifier)));
                continue;
            }
            return blockCapability;
        }
        return null;
    }

    @Nullable
    public static <T extends BlockCapability> T getCapability(class_18 world, int x, int y, int z, Class<T> capabilityClass) {
        CapabilityRegistryEntry registryEntry = BlockCapabilityRegistry.getCapabilityRegistryEntry(capabilityClass);
        if (registryEntry == null) {
            NyaLib.LOGGER.warn("Non-existent block capability requested: " + capabilityClass.getName());
            return null;
        }
        for (BlockCapabilityProvider provider : registryEntry.providers) {
            Object blockCapability = provider.getCapability(world, x, y, z);
            if (blockCapability == null) continue;
            if (!capabilityClass.isAssignableFrom(blockCapability.getClass())) {
                NyaLib.LOGGER.warn("Provider " + blockCapability.getClass().getName() + " does not implement " + String.valueOf(capabilityClass));
                continue;
            }
            return (T)((BlockCapability)capabilityClass.cast(blockCapability));
        }
        return null;
    }

    public static CapabilityRegistryEntry getCapabilityRegistryEntry(Identifier identifier) {
        return BlockCapabilityRegistry.getInstance().providerRegistry.get(identifier);
    }

    public static CapabilityRegistryEntry getCapabilityRegistryEntry(Class capabilityClass) {
        return BlockCapabilityRegistry.getInstance().registryEntryClassLookup.get(capabilityClass);
    }

    public static class CapabilityRegistryEntry {
        public Identifier identifier;
        public ArrayList<BlockCapabilityProvider> providers;
        public Class<? extends BlockCapability> capabilityClass;

        public CapabilityRegistryEntry(Identifier identifier, ArrayList<BlockCapabilityProvider> providers, Class<? extends BlockCapability> capabilityClass) {
            this.providers = providers;
            this.capabilityClass = capabilityClass;
        }
    }
}

