/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.capability.item;

import java.util.ArrayList;
import java.util.HashMap;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.capability.item.ItemCapability;
import net.danygames2014.nyalib.capability.item.ItemCapabilityProvider;
import net.danygames2014.nyalib.util.ClassUtil;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class ItemCapabilityRegistry {
    private static ItemCapabilityRegistry INSTANCE;
    private final HashMap<Identifier, CapabilityRegistryEntry> providerRegistry = new HashMap();
    private final HashMap<Class, CapabilityRegistryEntry> registryEntryClassLookup = new HashMap();

    public static ItemCapabilityRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ItemCapabilityRegistry();
        }
        return INSTANCE;
    }

    public static void registerCapabilityClass(Identifier identifier, Class<? extends ItemCapability> capabilityClass) {
        HashMap<Identifier, CapabilityRegistryEntry> r = ItemCapabilityRegistry.getInstance().providerRegistry;
        HashMap<Class, CapabilityRegistryEntry> lookup = ItemCapabilityRegistry.getInstance().registryEntryClassLookup;
        if (r.containsKey(identifier)) {
            NyaLib.LOGGER.warn("Attempted to register a item capability class for " + String.valueOf(identifier) + " but a class has already been registered before.");
            NyaLib.LOGGER.warn("Already registered class:" + r.get((Object)identifier).capabilityClass.getName());
            NyaLib.LOGGER.warn("Class being registered:" + r.get((Object)identifier).capabilityClass.getName());
            return;
        }
        r.put(identifier, new CapabilityRegistryEntry(identifier, new ArrayList<ItemCapabilityProvider>(), capabilityClass));
        lookup.put(capabilityClass, r.get(identifier));
        NyaLib.LOGGER.info("Registered item capability class " + capabilityClass.getName() + " for " + String.valueOf(identifier));
    }

    public static void register(Identifier identifier, ItemCapabilityProvider provider) {
        HashMap<Identifier, CapabilityRegistryEntry> r = ItemCapabilityRegistry.getInstance().providerRegistry;
        HashMap<Class, CapabilityRegistryEntry> lookup = ItemCapabilityRegistry.getInstance().registryEntryClassLookup;
        if (!r.containsKey(identifier)) {
            Class capabilityClass = ClassUtil.getGenericSuperclass((Object)provider, ItemCapability.class);
            if (ItemCapability.class.isAssignableFrom(capabilityClass)) {
                r.put(identifier, new CapabilityRegistryEntry(identifier, new ArrayList<ItemCapabilityProvider>(), capabilityClass));
                lookup.put(capabilityClass, r.get(identifier));
                NyaLib.LOGGER.warn("Provider for " + String.valueOf(identifier) + " is being registered, but no capability class has been registered. Using the " + String.valueOf(capabilityClass) + " class.");
            } else {
                NyaLib.LOGGER.error("Fallback lookup for item capability class for " + String.valueOf(identifier) + " failed");
                return;
            }
        }
        r.get((Object)identifier).providers.add(provider);
        NyaLib.LOGGER.info("Provider " + provider.getClass().getName() + " registered for capability " + String.valueOf(identifier));
    }

    @Nullable
    public static <T extends ItemCapability> T getCapability(class_31 stack, Identifier identifier) {
        CapabilityRegistryEntry registryEntry = ItemCapabilityRegistry.getCapabilityRegistryEntry(identifier);
        if (registryEntry == null) {
            NyaLib.LOGGER.warn("Non-existent item capability requested: " + String.valueOf(identifier));
            return null;
        }
        for (ItemCapabilityProvider provider : registryEntry.providers) {
            Object ItemCapability2 = provider.getCapability(stack);
            if (ItemCapability2 == null) continue;
            if (!registryEntry.capabilityClass.isAssignableFrom(ItemCapability2.getClass())) {
                NyaLib.LOGGER.warn("Provider " + ItemCapability2.getClass().getName() + " does not implement " + String.valueOf(ItemCapabilityRegistry.getCapabilityRegistryEntry(identifier)));
                continue;
            }
            return ItemCapability2;
        }
        return null;
    }

    @Nullable
    public static <T extends ItemCapability> T getCapability(class_31 stack, Class<T> capabilityClass) {
        CapabilityRegistryEntry registryEntry = ItemCapabilityRegistry.getCapabilityRegistryEntry(capabilityClass);
        if (registryEntry == null) {
            NyaLib.LOGGER.warn("Non-existent ItemStack capability requested: " + capabilityClass.getName());
            return null;
        }
        for (ItemCapabilityProvider provider : registryEntry.providers) {
            Object ItemCapability2 = provider.getCapability(stack);
            if (ItemCapability2 == null) continue;
            if (!capabilityClass.isAssignableFrom(ItemCapability2.getClass())) {
                NyaLib.LOGGER.warn("Provider " + ItemCapability2.getClass().getName() + " does not implement " + String.valueOf(capabilityClass));
                continue;
            }
            return (T)((ItemCapability)capabilityClass.cast(ItemCapability2));
        }
        return null;
    }

    public static CapabilityRegistryEntry getCapabilityRegistryEntry(Identifier identifier) {
        return ItemCapabilityRegistry.getInstance().providerRegistry.get(identifier);
    }

    public static CapabilityRegistryEntry getCapabilityRegistryEntry(Class capabilityClass) {
        return ItemCapabilityRegistry.getInstance().registryEntryClassLookup.get(capabilityClass);
    }

    public static class CapabilityRegistryEntry {
        public Identifier identifier;
        public ArrayList<ItemCapabilityProvider> providers;
        public Class<? extends ItemCapability> capabilityClass;

        public CapabilityRegistryEntry(Identifier identifier, ArrayList<ItemCapabilityProvider> providers, Class<? extends ItemCapability> capabilityClass) {
            this.providers = providers;
            this.capabilityClass = capabilityClass;
        }
    }
}

