/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.compat.whatsthis.elements;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.danygames2014.nyalib.compat.whatsthis.NyaLibRenderHelper;
import net.danygames2014.nyalib.compat.whatsthis.styles.ProgressStyleTank;
import net.danygames2014.nyalib.init.ProbeInfoProviderListener;
import net.danygames2014.whatsthis.api.IElement;
import net.danygames2014.whatsthis.api.IProgressStyle;
import net.danygames2014.whatsthis.apiimpl.client.ElementProgressRender;
import net.danygames2014.whatsthis.apiimpl.client.ElementTextRender;
import net.danygames2014.whatsthis.rendering.RenderHelper;
import net.minecraft.class_629;
import net.minecraft.client.Minecraft;

public class ElementTankGauge
implements IElement {
    private final String tankName;
    private final String fluidName;
    private final int amount;
    private final int capacity;
    private final String suffix;
    private final int color1;
    private final int color2;
    private final boolean sneaking;

    public ElementTankGauge(String tankName, String fluidName, int amount, int capacity, String suffix, int color1, boolean sneaking) {
        this.tankName = tankName;
        this.fluidName = fluidName;
        this.amount = amount;
        this.capacity = capacity;
        this.suffix = suffix;
        this.color1 = color1;
        this.color2 = new Color(this.color1).darker().hashCode();
        this.sneaking = sneaking;
    }

    public ElementTankGauge(DataInputStream stream) throws IOException {
        this.tankName = stream.readUTF();
        this.fluidName = stream.readUTF();
        this.amount = stream.readInt();
        this.capacity = stream.readInt();
        this.suffix = stream.readUTF();
        this.color1 = stream.readInt();
        this.color2 = new Color(this.color1).darker().hashCode();
        this.sneaking = stream.readBoolean();
    }

    public void toBytes(DataOutputStream stream) throws IOException {
        stream.writeUTF(this.tankName);
        stream.writeUTF(this.fluidName);
        stream.writeInt(this.amount);
        stream.writeInt(this.capacity);
        stream.writeUTF(this.suffix);
        stream.writeInt(this.color1);
        stream.writeBoolean(this.sneaking);
    }

    public void render(int x, int y) {
        if (this.capacity > 0) {
            ElementProgressRender.render((IProgressStyle)new ProgressStyleTank().filledColor(this.color1).alternateFilledColor(this.color2), (long)this.amount, (long)this.capacity, (int)x, (int)y, (int)100, (int)(this.sneaking ? 12 : 8));
        } else {
            ElementProgressRender.render((IProgressStyle)new ProgressStyleTank(), (long)this.amount, (long)this.capacity, (int)x, (int)y, (int)100, (int)(this.sneaking ? 12 : 8));
        }
        if (this.sneaking) {
            for (int i = 1; i < 10; ++i) {
                RenderHelper.drawVerticalLine((int)(x + i * 10), (int)(y + 1), (int)(y + (i == 5 ? 11 : 6)), (int)-9013642);
            }
            ElementTextRender.render((String)(this.capacity > 0 ? this.amount + "/" + this.capacity + " " + this.suffix : class_629.method_2049((String)"topaddons:tank_empty")), (int)(x + 3), (int)(y + 2));
            NyaLibRenderHelper.drawSmallText(x + 99 - Minecraft.field_2791.field_2815.method_1901(this.fluidName) / 2, y + 13, this.fluidName, this.color1);
        }
        NyaLibRenderHelper.drawSmallText(this.sneaking ? x + 1 : x + 2, this.sneaking ? y + 13 : y + 2, this.tankName, -1);
        RenderHelper.drawVerticalLine((int)(x + 99), (int)y, (int)(y + (this.sneaking ? 12 : 8)), (int)-6908266);
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return this.sneaking ? 18 : 8;
    }

    public int getID() {
        return ProbeInfoProviderListener.ELEMENT_TANK_GAUGE;
    }
}

