package net.danygames2014.nyalib.compat.whatsthis.providers;

import net.danygames2014.nyalib.NyaLibCompat;
import net.danygames2014.nyalib.capability.CapabilityHelper;
import net.danygames2014.nyalib.capability.block.energyhandler.EnergyStorageBlockCapability;
import net.danygames2014.nyalib.energy.EnergyConductor;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkManager;
import net.danygames2014.nyalib.network.NetworkType;
import net.danygames2014.nyalib.network.energy.EnergyNetwork;
import net.danygames2014.whatsthis.api.IProbeHitData;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.IProbeInfoProvider;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.config.Config;
import net.minecraft.class_18;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;

public class EnergyBlockProbeInfoProvider implements IProbeInfoProvider {
    int borderColor;
    int filledColor;
    int alternateFilledColor;

    public EnergyBlockProbeInfoProvider() {
        borderColor = Config.parseColor(Config.PROBE_CONFIG.rfbarBorderColor);
        filledColor = Config.parseColor(Config.PROBE_CONFIG.rfbarFilledColor);
        alternateFilledColor = Config.parseColor(Config.PROBE_CONFIG.rfbarAlternateFilledColor);
    }

    @Override
    public String getID() {
        return NyaLibCompat.NAMESPACE.id("nyalib_block_energy").toString();
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, BlockState state, IProbeHitData data) {
        class_339 pos = data.getPos();

        EnergyStorageBlockCapability energyStorage = CapabilityHelper.getCapability(world, pos.field_2100, pos.field_2101, pos.field_2102, EnergyStorageBlockCapability.class);
        if (energyStorage != null) {
            probeInfo.progress(
                    energyStorage.getEnergyStored(),
                    energyStorage.getEnergyCapacity(),
                    probeInfo.defaultProgressStyle().suffix(" EU")
                            .borderColor(borderColor)
                            .filledColor(filledColor)
                            .alternateFilledColor(alternateFilledColor)
            );
        }

        if (world.getBlockState(pos).getBlock() instanceof EnergyConductor) {
            Network net = NetworkManager.getAt(world.field_216, pos.field_2100, pos.field_2101, pos.field_2102, NetworkType.ENERGY.getIdentifier());
            if (net instanceof EnergyNetwork energyNet) {
                EnergyNetwork.EnergyFlowEntry flowEntry = energyNet.getFlowEntry(pos.field_2100, pos.field_2101, pos.field_2102);
                if (flowEntry != null) {
                    probeInfo.progress(
                            flowEntry.energyFlow,
                            flowEntry.conductor.getBreakdownPower(world, flowEntry.componentEntry),
                            probeInfo.defaultProgressStyle().suffix(" EU/t")
                                    .borderColor(borderColor)
                                    .filledColor(filledColor)
                                    .alternateFilledColor(alternateFilledColor)
                    );
                }
            }
        }
    }
}
