/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.compat.whatsthis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.danygames2014.nyalib.capability.CapabilityHelper;
import net.danygames2014.nyalib.capability.entity.itemhandler.ItemHandlerEntityCapability;
import net.danygames2014.whatsthis.Util;
import net.danygames2014.whatsthis.api.ElementAlignment;
import net.danygames2014.whatsthis.api.ILayoutStyle;
import net.danygames2014.whatsthis.api.IProbeConfig;
import net.danygames2014.whatsthis.api.IProbeInfo;
import net.danygames2014.whatsthis.api.ProbeMode;
import net.danygames2014.whatsthis.api.TextStyleClass;
import net.danygames2014.whatsthis.apiimpl.styles.ItemStyle;
import net.danygames2014.whatsthis.apiimpl.styles.LayoutStyle;
import net.danygames2014.whatsthis.config.Config;
import net.danygames2014.whatsthis.config.ConfigSetup;
import net.minecraft.class_124;
import net.minecraft.class_18;
import net.minecraft.class_206;
import net.minecraft.class_31;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.util.Identifier;

public class EntityInventoryInfo {
    static void showInventoryInfo(ProbeMode mode, IProbeInfo probeInfo, class_18 world, class_57 entity, IProbeConfig config) {
        IProbeConfig.ConfigMode chestMode = config.getShowChestContents();
        ArrayList<Object> stacks = null;
        if (!(chestMode != IProbeConfig.ConfigMode.EXTENDED || Config.PROBE_CONFIG.showSmallChestContentsWithoutSneaking <= 0 && ConfigSetup.getInventoriesToShow().isEmpty())) {
            int slots;
            if (ConfigSetup.getInventoriesToShow().contains(Identifier.of((String)class_206.method_734((class_57)entity)))) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            } else if (Config.PROBE_CONFIG.showSmallChestContentsWithoutSneaking > 0 && (slots = EntityInventoryInfo.getInventoryContents(world, entity, stacks = new ArrayList())) <= Config.PROBE_CONFIG.showSmallChestContentsWithoutSneaking) {
                chestMode = IProbeConfig.ConfigMode.NORMAL;
            }
        } else if (chestMode == IProbeConfig.ConfigMode.NORMAL && !ConfigSetup.getInventoriesToNotShow().isEmpty() && ConfigSetup.getInventoriesToNotShow().contains(Identifier.of((String)class_206.method_734((class_57)entity)))) {
            chestMode = IProbeConfig.ConfigMode.EXTENDED;
        }
        if (Util.show((ProbeMode)mode, (IProbeConfig.ConfigMode)chestMode)) {
            if (stacks == null) {
                stacks = new ArrayList<class_31>();
                EntityInventoryInfo.getInventoryContents(world, entity, stacks);
            }
            if (!stacks.isEmpty()) {
                boolean showDetailed = Util.show((ProbeMode)mode, (IProbeConfig.ConfigMode)config.getShowChestContentsDetailed()) && stacks.size() <= Config.PROBE_CONFIG.showItemDetailThreshold;
                EntityInventoryInfo.showInventoryContents(probeInfo, world, entity, stacks, showDetailed);
            }
        }
    }

    private static void showInventoryContents(IProbeInfo probeInfo, class_18 world, class_57 entity, List<class_31> stacks, boolean detailed) {
        IProbeInfo vertical = null;
        IProbeInfo horizontal = null;
        int rows = 0;
        int idx = 0;
        vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.parseColor((String)Config.CLIENT_CONFIG.chestContentsBorderColor))).spacing(0));
        if (detailed) {
            for (class_31 stackInSlot : stacks) {
                horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text(String.valueOf(TextStyleClass.INFO) + stackInSlot.method_694().method_469());
            }
        } else {
            for (class_31 stackInSlot : stacks) {
                if (idx % 10 == 0) {
                    horizontal = vertical.horizontal((ILayoutStyle)new LayoutStyle().spacing(0));
                    if (++rows > 4) break;
                }
                horizontal.item(stackInSlot);
                ++idx;
            }
        }
    }

    private static int getInventoryContents(class_18 world, class_57 entity, List<class_31> stacks) {
        HashSet<class_124> foundItems = Config.CLIENT_CONFIG.compactEqualStacks != false ? new HashSet<class_124>() : null;
        int inventorySize = 0;
        try {
            ItemHandlerEntityCapability itemHandler = (ItemHandlerEntityCapability)CapabilityHelper.getCapability((class_57)entity, ItemHandlerEntityCapability.class);
            if (itemHandler != null) {
                inventorySize = itemHandler.getItemSlots();
                for (int i = 0; i < inventorySize; ++i) {
                    EntityInventoryInfo.addItemStack(stacks, foundItems, itemHandler.getItem(i));
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Getting the contents of a " + class_206.method_734((class_57)entity) + " (" + entity.getClass().getName() + ")", e);
        }
        return inventorySize;
    }

    private static void addItemStack(List<class_31> stacks, Set<class_124> foundItems, class_31 stack) {
        if (stack == null || stack.method_694() == null || stack.field_751 <= 0) {
            return;
        }
        if (foundItems != null && foundItems.contains(stack.method_694())) {
            for (class_31 s : stacks) {
                if (!s.method_702(stack)) continue;
                s.field_751 += stack.field_751;
                return;
            }
        }
        stacks.add(stack.method_724());
        if (foundItems != null) {
            foundItems.add(stack.method_694());
        }
    }
}

