package net.danygames2014.nyalib.compat.whatsthis;

import net.danygames2014.nyalib.NyaLibCompat;
import net.danygames2014.nyalib.capability.CapabilityHelper;
import net.danygames2014.nyalib.capability.entity.energyhandler.EnergyStorageEntityCapability;
import net.danygames2014.whatsthis.api.*;
import net.danygames2014.whatsthis.config.Config;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_57;

public class EnergyEntityProbeInfoProvider implements IProbeInfoEntityProvider {
    int borderColor;
    int filledColor;
    int alternateFilledColor;

    public EnergyEntityProbeInfoProvider() {
        borderColor = Config.parseColor(Config.PROBE_CONFIG.rfbarBorderColor);
        filledColor = Config.parseColor(Config.PROBE_CONFIG.rfbarFilledColor);
        alternateFilledColor = Config.parseColor(Config.PROBE_CONFIG.rfbarAlternateFilledColor);
    }

    @Override
    public String getID() {
        return NyaLibCompat.NAMESPACE.id("nyalib_entity_energy").toString();
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, class_54 player, class_18 world, class_57 entity, IProbeHitEntityData data) {
        EnergyStorageEntityCapability energyStorage = CapabilityHelper.getCapability(entity, EnergyStorageEntityCapability.class);
        if (energyStorage != null) {
            probeInfo.progress(
                    energyStorage.getEnergyStored(),
                    energyStorage.getEnergyCapacity(),
                    probeInfo.defaultProgressStyle().suffix(" EU")
                            .borderColor(borderColor)
                            .filledColor(filledColor)
                            .alternateFilledColor(alternateFilledColor)
            );
        }
    }
}
