/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network.energy;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.energy.EnergyConductor;
import net.danygames2014.nyalib.energy.EnergyConsumer;
import net.danygames2014.nyalib.energy.EnergySource;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponentEntry;
import net.danygames2014.nyalib.network.NetworkEdgeComponent;
import net.danygames2014.nyalib.network.NetworkNodeComponent;
import net.danygames2014.nyalib.network.NetworkPath;
import net.danygames2014.nyalib.network.NetworkType;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

public class EnergyNetwork
extends Network {
    private final HashMap<class_63, ConsumerEntry> consumers = new HashMap();
    private final HashMap<class_63, ArrayList<ConsumerPath>> consumerCache = new HashMap();
    private final Object2ObjectOpenHashMap<class_63, EnergyFlowEntry> energyFlow = new Object2ObjectOpenHashMap();

    public EnergyNetwork(class_18 world, NetworkType type) {
        super(world, type);
    }

    public void update() {
        this.consumers.clear();
        this.consumerCache.clear();
        this.energyFlow.clear();
        for (NetworkComponentEntry componentEntry : this.components.values()) {
            class_17 class_172;
            if (componentEntry.component() instanceof NetworkEdgeComponent) {
                class_172 = this.world.method_1777(componentEntry.pos().field_1482, componentEntry.pos().field_1483, componentEntry.pos().field_1484);
                if (!(class_172 instanceof EnergyConsumer)) continue;
                EnergyConsumer consumer = (EnergyConsumer)class_172;
                this.consumers.put(componentEntry.pos(), new ConsumerEntry(componentEntry, consumer));
                continue;
            }
            if (!(componentEntry.component() instanceof NetworkNodeComponent) || !((class_172 = componentEntry.block()) instanceof EnergyConductor)) continue;
            EnergyConductor conductor = (EnergyConductor)class_172;
            this.energyFlow.put((Object)componentEntry.pos(), (Object)new EnergyFlowEntry(componentEntry, conductor, 0));
        }
        super.update();
    }

    public void tick() {
        super.tick();
        for (EnergyFlowEntry entry : this.energyFlow.values()) {
            entry.energyFlow = 0;
        }
    }

    public int provideEnergy(EnergySource source, class_63 sourcePos, int voltage, int energy) {
        int remainingEnergy = energy;
        for (ConsumerPath consumerPath : this.getValidConsumers(sourcePos)) {
            int usedEnergy;
            EnergyConsumer consumer = consumerPath.consumer;
            NetworkPath path = consumerPath.path;
            if (consumer.getRemainingCapacity() <= 0 || (remainingEnergy -= (usedEnergy = this.traverseEnergy(consumer, path.endFace, path, voltage, remainingEnergy))) > 0) continue;
            return energy;
        }
        return energy - remainingEnergy;
    }

    private int traverseEnergy(EnergyConsumer consumer, Direction consumerFace, NetworkPath path, int voltage, int energy) {
        int providedEnergy = consumer.receiveEnergy(consumerFace, voltage, energy);
        for (class_63 node : path.path) {
            EnergyFlowEntry flowEntry = (EnergyFlowEntry)this.energyFlow.get((Object)node);
            if (flowEntry == null) continue;
            flowEntry.energyFlow += providedEnergy;
            if (voltage > flowEntry.conductor.getBreakdownVoltage(this.world, flowEntry.componentEntry)) {
                flowEntry.conductor.onBreakdownVoltage(this.world, flowEntry.componentEntry, voltage);
            }
            if (flowEntry.energyFlow <= flowEntry.conductor.getBreakdownPower(this.world, flowEntry.componentEntry)) continue;
            flowEntry.conductor.onBreakdownPower(this.world, flowEntry.componentEntry, voltage, flowEntry.energyFlow);
        }
        return providedEnergy;
    }

    public ArrayList<ConsumerPath> getValidConsumers(class_63 source) {
        if (this.consumerCache.containsKey(source)) {
            return this.consumerCache.get(source);
        }
        ArrayList<ConsumerPath> consumers = new ArrayList<ConsumerPath>();
        for (Map.Entry<class_63, ConsumerEntry> consumer : this.consumers.entrySet()) {
            if (consumer.getKey().equals((Object)source)) continue;
            NetworkPath path = this.getPath(source, consumer.getKey());
            if (path == null) {
                NyaLib.LOGGER.debug("Path was null when getting valid consumers");
                continue;
            }
            if (!consumer.getValue().consumer.canReceiveEnergy(path.endFace)) continue;
            consumers.add(new ConsumerPath(consumer.getValue().consumer, path));
        }
        this.consumerCache.put(source, consumers);
        return consumers;
    }

    public EnergyFlowEntry getFlowEntry(int x, int y, int z) {
        return this.getFlowEntry(new class_63(x, y, z));
    }

    public EnergyFlowEntry getFlowEntry(class_63 pos) {
        return (EnergyFlowEntry)this.energyFlow.get((Object)pos);
    }

    public record ConsumerEntry(NetworkComponentEntry componentEntry, EnergyConsumer consumer) {
    }

    public static final class EnergyFlowEntry {
        public final NetworkComponentEntry componentEntry;
        public final EnergyConductor conductor;
        public int energyFlow;

        public EnergyFlowEntry(NetworkComponentEntry componentEntry, EnergyConductor conductor, int energyFlow) {
            this.componentEntry = componentEntry;
            this.conductor = conductor;
            this.energyFlow = energyFlow;
        }
    }

    public record ConsumerPath(EnergyConsumer consumer, NetworkPath path) {
    }
}

