/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.energy;

public interface EnergyStorageEntity {
    public int getEnergyStored();

    public int getEnergyCapacity();

    default public int getRemainingCapacity() {
        return this.getEnergyCapacity() - this.getEnergyStored();
    }

    public int setEnergy(int var1);

    default public int changeEnergy(int difference) {
        int prevEnergy = this.getEnergyStored();
        int desiredEnergy = prevEnergy + difference;
        if (desiredEnergy > this.getEnergyCapacity()) {
            this.setEnergy(this.getEnergyCapacity());
        } else if (desiredEnergy < 0) {
            this.setEnergy(0);
        } else {
            this.setEnergy(desiredEnergy);
        }
        int newEnergy = this.getEnergyStored();
        return newEnergy - prevEnergy;
    }

    default public int addEnergy(int amount) {
        return this.changeEnergy(amount);
    }

    default public int removeEnergy(int amount) {
        return Math.abs(this.changeEnergy(-amount));
    }

    public boolean canReceiveEnergy();

    public int getMaxEnergyInput();

    default public int receiveEnergy(int energy) {
        if (energy <= 0) {
            return 0;
        }
        if (this.getRemainingCapacity() <= 0) {
            return 0;
        }
        return this.addEnergy(Math.min(energy, this.getMaxEnergyInput()));
    }

    public boolean canExtractEnergy();

    public int getMaxEnergyOutput();

    default public int extractEnergy(int requestedEnergy) {
        if (!this.canExtractEnergy()) {
            return 0;
        }
        if (this.getEnergyStored() <= 0) {
            return 0;
        }
        return this.removeEnergy(Math.min(requestedEnergy, this.getMaxEnergyOutput()));
    }
}

