package net.danygames2014.nyalib.mixin.fluid;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.nyalib.block.FlowingFluidBlock;
import net.danygames2014.nyalib.block.StillFluidBlock;
import net.minecraft.class_15;
import net.minecraft.class_189;
import net.minecraft.class_40;
import net.minecraft.class_588;
import net.modificationstation.stationapi.api.block.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_588.class)
public class InGameHudMixin {
    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/ClientPlayerEntity;isInFluid(Lnet/minecraft/block/material/Material;)Z"))
    public boolean displayTheAirBar(class_40 player, class_15 material, Operation<Boolean> original){
        double eyeY = player.field_1601 + (double)player.method_1378();

        int blockX = class_189.method_645(player.field_1600);
        int blockY = class_189.method_648((float)class_189.method_645(eyeY));
        int blockZ = class_189.method_645(player.field_1602);

        BlockState state = player.field_1596.getBlockState(blockX, blockY, blockZ);

        if (state.getBlock() instanceof StillFluidBlock stillFluidBlock) {
            if (stillFluidBlock.fluid.willDrown(player)) {
                return player.method_1328(stillFluidBlock.fluid.getMaterial());
            }
        } else if (state.getBlock() instanceof FlowingFluidBlock flowingFluidBlock) {
            if (flowingFluidBlock.fluid.willDrown(player)) {
                return player.method_1328(flowingFluidBlock.fluid.getMaterial());
            }
        }

        return original.call(player, material);
    }
}
