package net.danygames2014.nyalib.mixin.fluid;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.danygames2014.nyalib.block.FlowingFluidBlock;
import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_26;
import net.minecraft.class_385;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_385.class)
public class LiquidBlockMixin {
    @Environment(EnvType.CLIENT)
    @Unique
    private static Fluid fluid;

    @Environment(EnvType.CLIENT)
    @WrapOperation(method = "getFlowingAngle", at = @At(value = "FIELD", target = "Lnet/minecraft/block/material/Material;WATER:Lnet/minecraft/block/material/Material;", ordinal = 0))
    private static class_15 injectFluidMaterial(Operation<class_15> original, @Local(argsOnly = true) class_14 view, @Local(ordinal = 0, argsOnly = true) int x, @Local(ordinal = 1, argsOnly = true) int y, @Local(ordinal = 2, argsOnly = true) int z) {
        fluid = FluidRegistry.get(view.method_1776(x, y, z));

        if (fluid != null) {
            return fluid.getFlowingBlock().field_1900;
        }
        
        return original.call();
    }
    
    @Environment(EnvType.CLIENT)
    @WrapOperation(method = "getFlowingAngle", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/LiquidBlock;getFlow(Lnet/minecraft/world/BlockView;III)Lnet/minecraft/util/math/Vec3d;", ordinal = 0))
    private static class_26 calculateFlow(class_385 instance, class_14 blockView, int x, int y, int z, Operation<class_26> original){
        if (fluid.getFlowingBlock() instanceof FlowingFluidBlock flowingFluidBlock) {
            class_26 flow = flowingFluidBlock.method_1219(blockView, x,y,z);
            fluid = null;
            return flow;
        }
        
        return original.call(instance, blockView, x, y, z);
    }
}
