package net.danygames2014.nyalib.mixin.fluid;

import net.danygames2014.nyalib.capability.CapabilityHelper;
import net.danygames2014.nyalib.capability.item.fluidhandler.FluidHandlerItemCapability;
import net.danygames2014.nyalib.fluid.FluidHandler;
import net.danygames2014.nyalib.fluid.FluidSlot;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.danygames2014.nyalib.screen.FluidScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_633;
import net.minecraft.class_71;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_71.class)
public abstract class ScreenHandlerMixin implements FluidScreenHandler {
    @Shadow
    public abstract void sendContentUpdates();

    @Shadow
    protected List listeners;
    @Unique
    public ArrayList<FluidStack> trackedFluidStacks = new ArrayList<>();
    @Unique
    public ArrayList<FluidSlot> fluidSlots = new ArrayList<>();

    @Override
    public void addFluidSlot(FluidSlot slot) {
        slot.id = fluidSlots.size();
        fluidSlots.add(slot);
        trackedFluidStacks.add(null);
    }

    @Override
    public ArrayList<FluidSlot> getFluidSlots() {
        return fluidSlots;
    }

    @Override
    public ArrayList<FluidStack> getFluidStacks() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<>();

        for (FluidSlot slot : fluidSlots) {
            fluidStacks.add(slot.getStack());
        }

        return fluidStacks;
    }

    @Inject(method = "sendContentUpdates", at = @At(value = "TAIL"))
    public void sendFluidContentUpdates(CallbackInfo ci) {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            FluidStack stack = this.fluidSlots.get(slot).getStack();
            FluidStack trackedStack = this.trackedFluidStacks.get(slot);
            if (!FluidStack.areEqual(trackedStack, stack)) {
                trackedStack = stack == null ? null : stack.copy();
                this.trackedFluidStacks.set(slot, trackedStack);

                for (Object listenerO : this.listeners) {
                    if (listenerO instanceof class_633 listener) {
                        listener.onFluidSlotUpdate((class_71) (Object) this, slot, trackedStack);
                    }
                }
            }
        }
    }

    @Override
    public FluidSlot getFluidSlot(int index) {
        if (index < 0 || index >= fluidSlots.size()) {
            return null;
        }

        return fluidSlots.get(index);
    }

    // TODO: This should probably return the cursor stack, since why would it return the fluid stack, literally not gonna get compared with client
    @Override
    public FluidStack onFluidSlotClick(int index, int button, boolean shift, class_54 player, class_31 cursorStack) {
        if (index == -999) {
            return null;
        }
        
        FluidSlot slot = fluidSlots.get(index);

        if (slot != null) {
            FluidHandler handler = slot.getHandler();

            if (cursorStack == null) {
                return slot.getStack();
            }
            
            FluidHandlerItemCapability cap = CapabilityHelper.getCapability(cursorStack, FluidHandlerItemCapability.class);
            
            if (cap != null) {
                FluidStack fluid = cap.getFluid(0);
                FluidStack invFluid = handler.getFluid(index, null);
                if (fluid != null) {
                    if (cap.canExtractFluid() && handler.canInsertFluid(null)) {
                        if (invFluid == null) {
                            FluidStack fluidStack = cap.extractFluid(handler.getRemainingFluidCapacity(index, null));
                            FluidStack remainder = handler.insertFluid(fluidStack, index, null);
                            if (remainder != null && remainder.amount > 0) {
                                cap.insertFluid(remainder);
                            }
                        } else if (invFluid.amount <= handler.getFluidCapacity(0, null)) {
                            FluidStack fluidStack = cap.extractFluid(handler.getRemainingFluidCapacity(index, null));
                            FluidStack remainder = handler.insertFluid(fluidStack, index, null);
                            if (remainder != null && remainder.amount > 0) {
                                cap.insertFluid(remainder);
                            }
                        } else if (invFluid.amount >= handler.getFluidCapacity(0, null)) {
                            if (cap.canInsertFluid() && handler.canExtractFluid(null)) {
                                FluidStack fluidStack = handler.extractFluid(index, cap.getRemainingFluidCapacity(0), null);
                                FluidStack remainder = cap.insertFluid(fluidStack);
                                if (remainder != null && remainder.amount > 0) {
                                    handler.insertFluid(remainder, index, null);
                                }
                            }
                        }
                    } else if (cap.canInsertFluid() && handler.canExtractFluid(null)) {
                        FluidStack fluidStack = handler.extractFluid(index, cap.getRemainingFluidCapacity(0), null);
                        FluidStack remainder = cap.insertFluid(fluidStack);
                        if (remainder != null && remainder.amount > 0) {
                            handler.insertFluid(remainder, index, null);
                        }
                    }
                } else if (cap.canInsertFluid() && handler.canExtractFluid(null)) {
                    FluidStack fluidStack = handler.extractFluid(index, cap.getRemainingFluidCapacity(0), null);
                    FluidStack remainder = cap.insertFluid(fluidStack);
                    if (remainder != null && remainder.amount > 0) {
                        handler.insertFluid(remainder, index, null);
                    }
                }
            }
        }

        sendContentUpdates();
        
        return slot != null ? slot.getStack() : null;
    }

    @Override
    public void onFluidSlotUpdate(FluidHandler handler) {
        this.sendContentUpdates();
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void setFluidStackInSlotClient(int index, FluidStack fluidStack) {
        FluidSlot slot = this.getFluidSlot(index);

        if (slot != null) {
            slot.setStack(fluidStack);
        }
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void updateFluidSlotStacksClient(FluidStack[] fluidStacks) {
        for (int i = 0; i < fluidStacks.length; i++) {
            this.setFluidStackInSlotClient(i, fluidStacks[i]);
        }
    }
}
