/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;

public class FluidStack {
    public Fluid fluid;
    public int amount;

    private FluidStack() {
    }

    private FluidStack(int amount) {
    }

    public FluidStack(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidStack(Identifier id) {
        this(id, 1000);
    }

    public FluidStack(Identifier id, int amount) {
        this.fluid = FluidRegistry.get(id);
        this.amount = amount;
    }

    public FluidStack(class_8 nbt) {
        this.readNbt(nbt);
    }

    public FluidStack copy() {
        return new FluidStack(this.fluid, this.amount);
    }

    public FluidStack(Fluid fluid) {
        this(fluid, 1000);
    }

    public String getTranslationKey() {
        return this.fluid.getTranslationKey(this);
    }

    public String getTranslatedName() {
        return this.fluid.getTranslatedName(this);
    }

    public boolean isFluidEqual(FluidStack other) {
        if (other == null) {
            return false;
        }
        return other.fluid == this.fluid;
    }

    public static boolean areEqual(FluidStack left, FluidStack right) {
        if (left == null && right == null) {
            return true;
        }
        return left != null && left.equals(right);
    }

    public final boolean equals(Object other) {
        if (other instanceof FluidStack) {
            FluidStack otherStack = (FluidStack)other;
            if (!this.isFluidEqual(otherStack)) {
                return false;
            }
            return this.amount == otherStack.amount;
        }
        return false;
    }

    public class_8 writeNbt(class_8 nbt) {
        nbt.method_1019("fluid", this.fluid.getIdentifier().toString());
        nbt.method_1015("amount", this.amount);
        return nbt;
    }

    public void readNbt(class_8 nbt) {
        this.fluid = FluidRegistry.get(Identifier.of((String)nbt.method_1031("fluid")));
        this.amount = nbt.method_1027("amount");
    }

    public FluidStack fromNbt(class_8 nbt) {
        FluidStack stack = new FluidStack();
        stack.readNbt(nbt);
        if (stack.fluid != null) {
            return stack;
        }
        return null;
    }

    public String toString() {
        return "FluidStack { Fluid = " + this.getTranslatedName() + " | Amount = " + this.amount + "mB }";
    }
}

