package net.danygames2014.nyalib.mixin.fluid;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.nyalib.block.FlowingFluidBlock;
import net.danygames2014.nyalib.block.StillFluidBlock;
import net.danygames2014.nyalib.fluid.Fluid;
import net.minecraft.class_127;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.block.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_127.class)
public abstract class LivingEntityMixin extends class_57 {
    public LivingEntityMixin(class_18 world) {
        super(world);
    }

    @Unique
    Fluid fluid;
    
    // Breathing (or lack thereof)
    @WrapOperation(method = "baseTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;isInFluid(Lnet/minecraft/block/material/Material;)Z"))
    public boolean checkIfInFluid(class_127 livingEntity, class_15 material, Operation<Boolean> original) {
        double eyeY = this.field_1601 + (double)this.method_1378();
        
        int blockX = class_189.method_645(this.field_1600);
        int blockY = class_189.method_648((float)class_189.method_645(eyeY));
        int blockZ = class_189.method_645(this.field_1602);

        BlockState state = field_1596.getBlockState(blockX, blockY, blockZ);

        if (state.getBlock() instanceof StillFluidBlock stillFluidBlock) {
            fluid = stillFluidBlock.fluid;
            return method_1328(stillFluidBlock.fluid.getMaterial());
        } else if (state.getBlock() instanceof FlowingFluidBlock flowingFluidBlock) {
            fluid = flowingFluidBlock.fluid;
            return method_1328(flowingFluidBlock.fluid.getMaterial());
        }
        
        fluid = null;
        return original.call(livingEntity, material);
    }
    
    @WrapOperation(method = "baseTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;canBreatheInWater()Z"))
    public boolean canBreatheInFluid(class_127 livingEntity, Operation<Boolean> original) {
        if (fluid != null) {
            return !fluid.willDrown(livingEntity);
        }
        
        return original.call(livingEntity);
    }
    
    // Movement Speed Multiplier
    @Unique
    public double movementMultiplier = 1.0D;

    @Inject(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;move(DDD)V", ordinal = 0))
    public void gatherFluidMovementMultiplier(float moveX, float moveZ, CallbackInfo ci) {
        class_17 block = this.field_1596.getBlockState(class_189.method_645(this.field_1600), class_189.method_645(this.field_1610.field_130), class_189.method_645(this.field_1602)).getBlock();

        if (block instanceof StillFluidBlock stillFluidBlock) {
            movementMultiplier = stillFluidBlock.fluid.getMovementSpeedMultiplier((class_127) (Object) this);
            return;
        } else if (block instanceof FlowingFluidBlock flowingFluidBlock) {
            movementMultiplier = flowingFluidBlock.fluid.getMovementSpeedMultiplier((class_127) (Object) this);
            return;
        }

        movementMultiplier = 1.0D;
    }

    @ModifyExpressionValue(method = "travel", at = @At(value = "CONSTANT", args = "doubleValue=0.800000011920929"))
    public double aVoid(double original) {
        if (movementMultiplier != 1.0D) {
            return movementMultiplier;   
        }
        
        return original;
    }
}
