package net.danygames2014.nyalib.mixin.fluid;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.danygames2014.nyalib.block.StillFluidBlock;
import net.minecraft.class_18;
import net.minecraft.class_315;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_315.class)
public class StillLiquidBlockMixin {
    @WrapOperation(method = "convertToFlowing", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;setBlockWithoutNotifyingNeighbors(IIIII)Z"))
    public boolean injectCorrectFLowingBlockId(class_18 world, int x, int y, int z, int blockId, int meta, Operation<Boolean> original){
        if (world.getBlockState(x, y, z).getBlock() instanceof StillFluidBlock stillFluidBlock) {
            return original.call(world, x, y, z, stillFluidBlock.fluid.getFlowingBlock().field_1915, meta);
        }

        return original.call(world, x, y, z, blockId, meta);
    }
}
