/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import java.util.HashMap;
import net.danygames2014.nyalib.NyaLibFluid;
import net.danygames2014.nyalib.fluid.Fluid;
import net.minecraft.class_17;
import net.modificationstation.stationapi.api.util.Identifier;

public class FluidRegistry {
    public final HashMap<Identifier, Fluid> registry = new HashMap();
    private static FluidRegistry INSTANCE;

    private static FluidRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FluidRegistry();
        }
        return INSTANCE;
    }

    public static void register(Fluid fluid) {
        FluidRegistry.register(fluid.getIdentifier(), fluid);
    }

    public static void register(Identifier identifier, Fluid fluid) {
        if (FluidRegistry.getInstance().registry.containsKey(identifier)) {
            return;
        }
        NyaLibFluid.LOGGER.info("Registering fluid {}", (Object)identifier);
        FluidRegistry.getInstance().registry.put(identifier, fluid);
    }

    public static Fluid get(Identifier identifier) {
        return FluidRegistry.getInstance().registry.getOrDefault(identifier, null);
    }

    public static Fluid get(int fluidBlockId) {
        for (Fluid fluid : FluidRegistry.getInstance().registry.values()) {
            class_17 stillBlock = fluid.getStillBlock();
            if (stillBlock != null && stillBlock.field_1915 == fluidBlockId) {
                return fluid;
            }
            class_17 flowingBlock = fluid.getFlowingBlock();
            if (flowingBlock == null || flowingBlock.field_1915 != fluidBlockId) continue;
            return fluid;
        }
        return null;
    }

    public static HashMap<Identifier, Fluid> getRegistry() {
        return FluidRegistry.getInstance().registry;
    }
}

