/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.mixin.fluid;

import java.util.ArrayList;
import java.util.List;
import net.danygames2014.nyalib.capability.CapabilityHelper;
import net.danygames2014.nyalib.capability.item.fluidhandler.FluidHandlerItemCapability;
import net.danygames2014.nyalib.fluid.FluidHandler;
import net.danygames2014.nyalib.fluid.FluidSlot;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.danygames2014.nyalib.screen.FluidScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_633;
import net.minecraft.class_71;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_71.class})
public abstract class ScreenHandlerMixin
implements FluidScreenHandler {
    @Shadow
    protected List field_2736;
    @Unique
    public ArrayList<FluidStack> trackedFluidStacks = new ArrayList();
    @Unique
    public ArrayList<FluidSlot> fluidSlots = new ArrayList();

    @Shadow
    public abstract void method_2075();

    @Override
    public void addFluidSlot(FluidSlot slot) {
        slot.id = this.fluidSlots.size();
        this.fluidSlots.add(slot);
        this.trackedFluidStacks.add(null);
    }

    @Override
    public ArrayList<FluidSlot> getFluidSlots() {
        return this.fluidSlots;
    }

    @Override
    public ArrayList<FluidStack> getFluidStacks() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (FluidSlot slot : this.fluidSlots) {
            fluidStacks.add(slot.getStack());
        }
        return fluidStacks;
    }

    @Inject(method={"method_2075()V"}, at={@At(value="TAIL")})
    public void sendFluidContentUpdates(CallbackInfo ci) {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            FluidStack stack = this.fluidSlots.get(slot).getStack();
            FluidStack trackedStack = this.trackedFluidStacks.get(slot);
            if (FluidStack.areEqual(trackedStack, stack)) continue;
            trackedStack = stack == null ? null : stack.copy();
            this.trackedFluidStacks.set(slot, trackedStack);
            for (Object listenerO : this.field_2736) {
                if (!(listenerO instanceof class_633)) continue;
                class_633 listener = (class_633)listenerO;
                listener.onFluidSlotUpdate((class_71)this, slot, trackedStack);
            }
        }
    }

    @Override
    public FluidSlot getFluidSlot(int index) {
        if (index < 0 || index >= this.fluidSlots.size()) {
            return null;
        }
        return this.fluidSlots.get(index);
    }

    @Override
    public FluidStack onFluidSlotClick(int index, int button, boolean shift, class_54 player, class_31 cursorStack) {
        if (index == -999) {
            return null;
        }
        FluidSlot slot = this.fluidSlots.get(index);
        if (slot != null) {
            FluidHandler handler = slot.getHandler();
            if (cursorStack == null) {
                return slot.getStack();
            }
            FluidHandlerItemCapability cap = (FluidHandlerItemCapability)CapabilityHelper.getCapability((class_31)cursorStack, FluidHandlerItemCapability.class);
            if (cap != null) {
                FluidStack fluidStack;
                FluidStack remainder;
                FluidStack fluid = cap.getFluid(0);
                FluidStack invFluid = handler.getFluid(index, null);
                if (fluid != null) {
                    FluidStack fluidStack2;
                    FluidStack remainder2;
                    if (cap.canExtractFluid() && handler.canInsertFluid(null)) {
                        FluidStack fluidStack3;
                        FluidStack remainder3;
                        if (invFluid == null) {
                            FluidStack fluidStack4 = cap.extractFluid(handler.getRemainingFluidCapacity(index, null));
                            FluidStack remainder4 = handler.insertFluid(fluidStack4, index, null);
                            if (remainder4 != null && remainder4.amount > 0) {
                                cap.insertFluid(remainder4);
                            }
                        } else if (invFluid.amount <= handler.getFluidCapacity(0, null)) {
                            FluidStack fluidStack5 = cap.extractFluid(handler.getRemainingFluidCapacity(index, null));
                            FluidStack remainder5 = handler.insertFluid(fluidStack5, index, null);
                            if (remainder5 != null && remainder5.amount > 0) {
                                cap.insertFluid(remainder5);
                            }
                        } else if (invFluid.amount >= handler.getFluidCapacity(0, null) && cap.canInsertFluid() && handler.canExtractFluid(null) && (remainder3 = cap.insertFluid(fluidStack3 = handler.extractFluid(index, cap.getRemainingFluidCapacity(0), null))) != null && remainder3.amount > 0) {
                            handler.insertFluid(remainder3, index, null);
                        }
                    } else if (cap.canInsertFluid() && handler.canExtractFluid(null) && (remainder2 = cap.insertFluid(fluidStack2 = handler.extractFluid(index, cap.getRemainingFluidCapacity(0), null))) != null && remainder2.amount > 0) {
                        handler.insertFluid(remainder2, index, null);
                    }
                } else if (cap.canInsertFluid() && handler.canExtractFluid(null) && (remainder = cap.insertFluid(fluidStack = handler.extractFluid(index, cap.getRemainingFluidCapacity(0), null))) != null && remainder.amount > 0) {
                    handler.insertFluid(remainder, index, null);
                }
            }
        }
        this.method_2075();
        return slot != null ? slot.getStack() : null;
    }

    @Override
    public void onFluidSlotUpdate(FluidHandler handler) {
        this.method_2075();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void setFluidStackInSlotClient(int index, FluidStack fluidStack) {
        FluidSlot slot = this.getFluidSlot(index);
        if (slot != null) {
            slot.setStack(fluidStack);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void updateFluidSlotStacksClient(FluidStack[] fluidStacks) {
        for (int i = 0; i < fluidStacks.length; ++i) {
            this.setFluidStackInSlotClient(i, fluidStacks[i]);
        }
    }
}

