/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.block;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.danygames2014.nyalib.block.FlowingFluidBlock;
import net.danygames2014.nyalib.block.FluidBlockTextureHolder;
import net.danygames2014.nyalib.block.JsonOverrideRegistry;
import net.danygames2014.nyalib.block.StillFluidBlock;
import net.danygames2014.nyalib.fluid.Fluid;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_259;
import net.minecraft.class_300;
import net.minecraft.class_406;
import net.modificationstation.stationapi.api.client.event.texture.TextureRegisterEvent;
import net.modificationstation.stationapi.api.client.resource.ReloadableAssetsManager;
import net.modificationstation.stationapi.api.resource.Resource;
import net.modificationstation.stationapi.api.util.Identifier;

public class FluidBlockManager {
    private static final HashMap<Fluid, FluidBlockEntry> fluidBlocks = new HashMap();
    public static final String fluidInventoryJson = "{\n  \"parent\": \"minecraft:item/generated\",\n  \"textures\": {\n  }\n}";

    public static void requestBlock(Fluid fluid, Identifier stillTexture, Identifier flowingTexture, Identifier overlayTexture, class_259 mapColor) {
        fluidBlocks.put(fluid, new FluidBlockEntry(fluid, stillTexture, flowingTexture, overlayTexture, mapColor));
    }

    public static void registerBlocks() {
        for (Map.Entry<Fluid, FluidBlockEntry> entry : fluidBlocks.entrySet()) {
            Fluid fluid = entry.getKey();
            class_406 fluidMaterial = new class_406(entry.getValue().mapColor);
            Identifier stillBlockIdentifier = fluid.getIdentifier().withSuffixedPath("_still");
            StillFluidBlock stillBlock = new StillFluidBlock(stillBlockIdentifier, (class_15)fluidMaterial, fluid);
            fluid.setStillBlock((class_17)stillBlock);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                JsonOverrideRegistry.registerItemModelOverride((Identifier)stillBlockIdentifier, (String)fluidInventoryJson);
                JsonOverrideRegistry.registerItemModelTextureOverride((Identifier)stillBlockIdentifier, (String)"layer0", (Identifier)entry.getValue().stillTexture);
            }
            Identifier flowingBlockIdentifier = fluid.getIdentifier().withSuffixedPath("_flowing");
            FlowingFluidBlock flowingFluidBlock = new FlowingFluidBlock(flowingBlockIdentifier, (class_15)fluidMaterial, fluid);
            fluid.setFlowingBlock((class_17)flowingFluidBlock);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            JsonOverrideRegistry.registerItemModelOverride((Identifier)flowingBlockIdentifier, (String)fluidInventoryJson);
            JsonOverrideRegistry.registerItemModelTextureOverride((Identifier)flowingBlockIdentifier, (String)"layer0", (Identifier)entry.getValue().flowingTexture);
        }
    }

    public static void registerTextures(TextureRegisterEvent event) {
        for (Map.Entry<Fluid, FluidBlockEntry> entry : fluidBlocks.entrySet()) {
            FluidBlockEntry fluidEntry = entry.getValue();
            FluidBlockTextureHolder textureHolder = new FluidBlockTextureHolder();
            textureHolder.addStillTexture(fluidEntry.stillTexture);
            textureHolder.addFlowingTexture(fluidEntry.flowingTexture);
            fluidEntry.setTextureHolder(textureHolder);
            if (fluidEntry.overlayTexture != null) {
                IntIntImmutablePair textureSize = FluidBlockManager.getTextureSize(fluidEntry.overlayTexture);
                textureHolder.addOverlayTexture(fluidEntry.overlayTexture, textureSize.leftInt(), textureSize.rightInt());
                continue;
            }
            textureHolder.overlaySpriteId = -1;
        }
    }

    public static IntIntImmutablePair getTextureSize(Identifier identifier) {
        Optional resource = ReloadableAssetsManager.INSTANCE.getResource(Identifier.of((String)("/assets/" + String.valueOf(identifier.namespace) + "/stationapi/textures/" + identifier.path + ".png")));
        if (resource.isPresent()) {
            try {
                BufferedImage image = ImageIO.read(((Resource)resource.get()).getInputStream());
                return new IntIntImmutablePair(image.getWidth(), image.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new IntIntImmutablePair(16, 16);
    }

    public static void registerTranslations() {
        class_300 translationStorage = class_300.method_992();
        String stillFluid = translationStorage.method_993("tile.fluid.nyalib.still");
        String flowingFluid = translationStorage.method_993("tile.fluid.nyalib.Flowing");
        for (Map.Entry<Fluid, FluidBlockEntry> entry : fluidBlocks.entrySet()) {
            Fluid fluid = entry.getKey();
            translationStorage.field_1174.put(fluid.getStillBlock().method_1597() + ".name", translationStorage.method_994(stillFluid, new Object[]{fluid.getTranslatedName()}));
            translationStorage.field_1174.put(fluid.getFlowingBlock().method_1597() + ".name", translationStorage.method_994(flowingFluid, new Object[]{fluid.getTranslatedName()}));
        }
    }

    public static class FluidBlockEntry {
        public Fluid fluid;
        public FluidBlockTextureHolder textureHolder;
        public Identifier stillTexture;
        public Identifier flowingTexture;
        public Identifier overlayTexture;
        public class_259 mapColor;

        public FluidBlockEntry(Fluid fluid, Identifier stillTexture, Identifier flowingTexture, Identifier overlayTexture, class_259 mapColor) {
            this.fluid = fluid;
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
            this.overlayTexture = overlayTexture;
            this.mapColor = mapColor;
        }

        public void setTextureHolder(FluidBlockTextureHolder textureHolder) {
            this.textureHolder = textureHolder;
            class_17 class_172 = this.fluid.getStillBlock();
            if (class_172 instanceof StillFluidBlock) {
                StillFluidBlock stillFluidBlock = (StillFluidBlock)class_172;
                stillFluidBlock.textureHolder = textureHolder;
                stillFluidBlock.field_1914 = textureHolder.getStillTextureId();
            }
            if ((class_172 = this.fluid.getFlowingBlock()) instanceof FlowingFluidBlock) {
                FlowingFluidBlock flowingFluidBlock = (FlowingFluidBlock)class_172;
                flowingFluidBlock.textureHolder = textureHolder;
                flowingFluidBlock.field_1914 = textureHolder.getFlowingTextureId();
            }
        }
    }
}

