/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_325;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.entity.player.PlayerHelper;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.SideUtil;
import org.jetbrains.annotations.NotNull;

public class ClickFluidSlotC2SPacket
extends class_169
implements ManagedPacket<ClickFluidSlotC2SPacket> {
    public static final PacketType<ClickFluidSlotC2SPacket> TYPE = PacketType.builder((boolean)false, (boolean)true, ClickFluidSlotC2SPacket::new).build();
    public int syncId;
    public int slot;
    public int button;
    public short actionType;
    public FluidStack stack;
    public boolean holdingShift;
    private int size = 9;

    public ClickFluidSlotC2SPacket() {
    }

    public ClickFluidSlotC2SPacket(int syncId, int slot, int button, boolean holdingShift, FluidStack stack, short actionType) {
        this.syncId = syncId;
        this.slot = slot;
        this.button = button;
        this.holdingShift = holdingShift;
        this.stack = stack;
        this.actionType = actionType;
    }

    public void method_806(DataInputStream stream) {
        try {
            this.syncId = stream.readByte();
            this.slot = stream.readShort();
            this.button = stream.readByte();
            this.actionType = stream.readShort();
            this.holdingShift = stream.readBoolean();
            String fluidIdentifier = stream.readUTF();
            if (!fluidIdentifier.isEmpty()) {
                int amount = stream.readInt();
                this.stack = new FluidStack(FluidRegistry.get(Identifier.of((String)fluidIdentifier)), amount);
            } else {
                this.stack = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();
            stream.writeByte(this.syncId);
            stream.writeShort(this.slot);
            stream.writeByte(this.button);
            stream.writeShort(this.actionType);
            stream.writeBoolean(this.holdingShift);
            if (this.stack == null) {
                stream.writeUTF("");
            } else {
                stream.writeUTF(this.stack.fluid.getIdentifier().toString());
                stream.writeInt(this.stack.amount);
            }
            this.size = stream.size() - initialStreamSize;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 networkHandler) {
        SideUtil.run(() -> {}, () -> this.handleServer(networkHandler));
    }

    @Environment(value=EnvType.SERVER)
    public void handleServer(class_240 handler) {
        class_54 class_542 = PlayerHelper.getPlayerFromPacketHandler((class_240)handler);
        if (class_542 instanceof class_69) {
            class_69 player = (class_69)class_542;
            if (handler instanceof class_11) {
                class_11 networkHandler = (class_11)handler;
                if (player.field_521.field_2735 == this.syncId && player.field_521.method_2085((class_54)player)) {
                    FluidStack clickResultStack = player.field_521.onFluidSlotClick(this.slot, this.button, this.holdingShift, (class_54)player, player.field_519.method_689());
                    System.out.println();
                    System.out.println(FluidStack.areEqual(this.stack, clickResultStack));
                    System.out.println(this.stack);
                    System.out.println(clickResultStack);
                    if (FluidStack.areEqual(this.stack, clickResultStack)) {
                        player.field_255.method_835((class_169)new class_325(this.syncId, this.actionType, true));
                        player.field_266 = true;
                        player.field_521.method_2075();
                        player.method_319();
                        player.field_266 = false;
                    } else {
                        networkHandler.field_929.put(player.field_521.field_2735, this.actionType);
                        player.field_255.method_835((class_169)new class_325(this.syncId, this.actionType, false));
                        player.field_521.method_2080((class_54)player, false);
                        ArrayList<FluidStack> var3 = new ArrayList<FluidStack>();
                        for (int i = 0; i < player.field_521.getFluidSlots().size(); ++i) {
                            var3.add(player.field_521.getFluidSlot(i).getStack());
                        }
                        player.onFluidContentsUpdate(player.field_521, var3);
                    }
                }
            }
        }
    }

    public int method_798() {
        return this.size;
    }

    @NotNull
    public PacketType<ClickFluidSlotC2SPacket> getType() {
        return TYPE;
    }
}

