package net.danygames2014.nyalib.mixin.fluid;

import com.llamalad7.mixinextras.sugar.Local;
import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidBucket;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.danygames2014.nyalib.sound.SoundHelper;
import net.minecraft.class_18;
import net.minecraft.class_220;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.States;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_220.class)
public class BucketItemMixin implements FluidBucket {
    @Shadow
    private int fluidBlockId;

    @Inject(method = "use", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;getMaterial(III)Lnet/minecraft/block/material/Material;", ordinal = 0, shift = At.Shift.BEFORE), cancellable = true)
    public void pain(class_31 stack, class_18 world, class_54 player, CallbackInfoReturnable<class_31> cir, @Local class_27 hitResult) {
        int x = hitResult.field_1984;
        int y = hitResult.field_1985;
        int z = hitResult.field_1986;

        Fluid fluid = FluidRegistry.get(world.method_1776(x, y, z));
        if (fluid != null && fluid.getBucketItem() != null) {
            world.setBlockStateWithNotify(x, y, z, States.AIR.get());
            SoundHelper.playSound(player, fluid.getFillSound(), 1.0F, 1.0F);
            cir.setReturnValue(new class_31(fluid.getBucketItem()));
        }
    }

    @Inject(method = "use", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;setBlock(IIIII)Z", ordinal = 0), cancellable = true)
    public void playEmptySound(class_31 stack, class_18 world, class_54 player, CallbackInfoReturnable<class_31> cir) {
        Fluid fluid = getFluid();
        
        if (!fluid.isPlaceableInWorld()) {
            cir.setReturnValue(stack);
        }

        SoundHelper.playSound(world, player.field_1600, player.field_1601, player.field_1602, fluid.getEmptySound(), 0.5F, 1.0F, 16);
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.get(fluidBlockId);
    }
}
