package net.danygames2014.nyalib.mixin.fluid;

import net.danygames2014.nyalib.block.FlowingFluidBlock;
import net.danygames2014.nyalib.block.StillFluidBlock;
import net.danygames2014.nyalib.entity.FluidEntity;
import net.danygames2014.nyalib.fluid.Fluid;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_25;
import net.minecraft.class_57;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_57.class)
public abstract class EntityMixin implements FluidEntity {
    @Shadow
    public abstract boolean isInFluid(class_15 material);

    @Shadow
    public class_18 world;

    @Shadow
    @Final
    public class_25 boundingBox;

    @Override
    public boolean isInFluid(Fluid fluid) {
        return this.isInFluid(fluid.getMaterial());
    }

    @Inject(method = "checkWaterCollisions", at = @At(value = "RETURN"), cancellable = true)
    public void swimming(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValue()) {
            class_25 entityBoundingBox = this.boundingBox.method_93(0.0D, -0.4D, 0.0D).method_104(0.001, 0.001, 0.001);
            int x1 = class_189.method_645(entityBoundingBox.field_129);
            int x2 = class_189.method_645(entityBoundingBox.field_132 + (double) 1.0F);
            int y1 = class_189.method_645(entityBoundingBox.field_130);
            int y2 = class_189.method_645(entityBoundingBox.field_133 + (double) 1.0F);
            int z1 = class_189.method_645(entityBoundingBox.field_131);
            int z2 = class_189.method_645(entityBoundingBox.field_134 + (double) 1.0F);

            if (!world.method_155(x1, y1, z1, x2, y2, z2)) {
                return;
            }

            class_57 thisEntity = (class_57) (Object) this;
            for (int blockX = x1; blockX < x2; ++blockX) {
                for (int blockY = y1; blockY < y2; ++blockY) {
                    for (int blockZ = z1; blockZ < z2; ++blockZ) {
                        class_17 block = class_17.field_1937[world.method_1776(blockX, blockY, blockZ)];

                        if (block instanceof StillFluidBlock stillFluidBlock) {
                            if (stillFluidBlock.fluid.canSwim(thisEntity)) {
                                if (this.world.method_170(this.boundingBox.method_93(0.0D, -0.4D, 0.0D).method_104(0.001, 0.001, 0.001), stillFluidBlock.fluid.getMaterial(), thisEntity)) {
                                    cir.setReturnValue(true);
                                    return;
                                }
                            }
                        }

                        if (block instanceof FlowingFluidBlock flowingFluidBlock) {
                            if (flowingFluidBlock.fluid.canSwim(thisEntity)) {
                                if (this.world.method_170(this.boundingBox.method_93(0.0D, -0.4D, 0.0D).method_104(0.001, 0.001, 0.001), flowingFluidBlock.fluid.getMaterial(), thisEntity)) {
                                    cir.setReturnValue(true);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
