package net.danygames2014.nyalib.mixin.fluid;

import com.llamalad7.mixinextras.sugar.Local;
import net.danygames2014.nyalib.fluid.FluidSlot;
import net.minecraft.class_293;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_71;
import net.minecraft.class_92;
import net.modificationstation.stationapi.api.util.Formatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_293.class)
public abstract class HandledScreenMixin extends class_32 {
    @Shadow
    public class_71 container;

    @Shadow
    public abstract void method_119();

    @Shadow
    protected int backgroundHeight;

    @Shadow
    protected int backgroundWidth;

    @Shadow
    private static class_92 itemRenderer;

    @Unique
    FluidSlot hoveredSlot = null;
    
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lorg/lwjgl/opengl/GL11;glEnable(I)V", ordinal = 0))
    public void renderFluidSlots(int mouseX, int mouseY, float delta, CallbackInfo ci) {
        hoveredSlot = null;
        
        for (FluidSlot fluidSlot : container.getFluidSlots()) {
            boolean hovered = isPointOverFluidSlot(fluidSlot, mouseX, mouseY);

            if (fluidSlot.getStack() != null) {
                class_31 renderedItem = new class_31(fluidSlot.getStack().fluid.getBucketFluid());
                itemRenderer.method_1487(this.field_156, this.field_151.field_2814, renderedItem, fluidSlot.x, fluidSlot.y);
                itemRenderer.method_1488(this.field_156, this.field_151.field_2814, renderedItem, fluidSlot.x, fluidSlot.y);
            }

            if (hoveredSlot == null && hovered) {
                hoveredSlot = fluidSlot;
                
                GL11.glDisable(GL11.GL_LIGHTING);
                GL11.glDisable(GL11.GL_DEPTH_TEST);
                this.method_1933(hoveredSlot.x, hoveredSlot.y, hoveredSlot.x + 16, hoveredSlot.y + 16, 0x80ffffff, 0x80ffffff);
                GL11.glEnable(GL11.GL_LIGHTING);
                GL11.glEnable(GL11.GL_DEPTH_TEST);
            }
        }
    }
    
    @Inject(method = "render",at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawForeground()V"))
    public void renderTooltip(int mouseX, int mouseY, float delta, CallbackInfo ci, @Local(ordinal = 2) int screenX, @Local(ordinal = 3) int screenY) {
        if (hoveredSlot != null) {
            String[] tooltip;
            
            if (!hoveredSlot.hasStack()) {
                tooltip = new String[1];
                tooltip[0] = "Empty";
            } else {
                tooltip = new String[2];
                tooltip[0] = hoveredSlot.getStack().fluid.getTranslatedName();
                tooltip[1] = Formatting.GRAY.toString() + hoveredSlot.getStack().amount + "/" + hoveredSlot.getMaxFluidAmount() + "mB";
            }
            
            // Calculate the tooltip length according to the longest line
            int textWidth = -1;
            for (String line : tooltip) {
                int lineWidth = this.field_156.method_1901(line);
                if (lineWidth > textWidth) {
                    textWidth = lineWidth;
                }
            }
            
            int textHeight = tooltip.length * 10;

            int x = (mouseX - screenX + 12);
            int y = (mouseY - screenY - 12);
            this.method_1933(x - 3, y - 3, x + textWidth + 3, y + textHeight + 3, -1073741824, -1073741824);
            
            for (int i = 0; i < tooltip.length; i++) {
                String line = tooltip[i];
                
                if (line != null && !line.isEmpty()) {
                    this.field_156.method_1903(line, x, y + (i * 12), -1);
                }
            }
        }
    }

    @Unique
    public boolean isPointOverFluidSlot(FluidSlot fluidSlot, int x, int y) {
        int centerX = (this.field_152 - this.backgroundWidth) / 2;
        int centerY = (this.field_153 - this.backgroundHeight) / 2;
        x -= centerX;
        y -= centerY;
        return x >= fluidSlot.x - 1 && x < fluidSlot.x + 16 + 1 && y >= fluidSlot.y - 1 && y < fluidSlot.y + 16 + 1;
    }
    
    @Unique
    public FluidSlot getFluidSlotAt(int x, int y) {
        for (FluidSlot fluidSlot : container.getFluidSlots()) {
            if (isPointOverFluidSlot(fluidSlot, x, y)) {
                return fluidSlot;
            }
        }
        
        return null;
    }
    
    @Inject(method = "mouseClicked", at = @At("TAIL"))
    public void mouseClickedFluid(int mouseX, int mouseY, int button, CallbackInfo ci){
        if (button == 0 || button == 1) {
            FluidSlot fluidSlot = this.getFluidSlotAt(mouseX, mouseY);
            int x = (this.field_152 - this.backgroundWidth) / 2;
            int y = (this.field_153 - this.backgroundHeight) / 2;
            boolean outside = mouseX < x || mouseY < y || mouseX >= x + this.backgroundWidth || mouseY >= y + this.backgroundHeight;
            
            int slotId = -1;
            
            if (fluidSlot != null) {
                slotId = fluidSlot.id;
            }

            if (outside) {
                slotId = -999;
            }

            if (slotId != -1) {
                boolean shift = slotId != -999 && (Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT));
                this.field_151.field_2801.clickFluidSlot(this.container.field_2735, slotId, button, shift, this.field_151.field_2806);
            }
        }
    }
}
