/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import java.awt.Color;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.block.FluidBlockManager;
import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.util.MapColorUtil;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_259;
import net.modificationstation.stationapi.api.util.Identifier;

public class FluidBuilder {
    private final Identifier identifier;
    private final class_17 stillBlock;
    private final class_17 flowingBlock;
    private final Identifier stillTexture;
    private final Identifier flowingTexture;
    private Identifier overlayTexture = null;
    private Integer bucketSize = null;
    private class_124 bucketItem = null;
    private Boolean placeableInWorld = null;
    private Boolean automaticBucketRegistration = null;
    private String fillSound = null;
    private String emptySound = null;
    private Integer color = null;
    private class_259 mapColor = null;
    private Integer tickRate = null;
    private Boolean canSwimIn = null;
    private Double movementSpeedMultiplier = null;
    private Boolean willDrown = null;
    private Integer lightLevel = null;
    private Integer colorMultiplier = null;

    public FluidBuilder(Identifier identifier, Identifier stillTexture, Identifier flowingTexture) {
        this.identifier = identifier;
        this.stillBlock = null;
        this.flowingBlock = null;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
    }

    public FluidBuilder(Identifier identifier, class_17 stillBlock, class_17 flowingBlock) {
        this.identifier = identifier;
        this.stillBlock = stillBlock;
        this.flowingBlock = flowingBlock;
        this.stillTexture = null;
        this.flowingTexture = null;
    }

    public FluidBuilder overlayTexture(Identifier overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public FluidBuilder mapColor(class_259 mapColor) {
        this.mapColor = mapColor;
        return this;
    }

    public FluidBuilder color(int color) {
        this.color = color;
        return this;
    }

    public FluidBuilder color(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public FluidBuilder bucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public FluidBuilder bucketItem(class_124 bucketItem) {
        this.bucketItem = bucketItem;
        return this;
    }

    public FluidBuilder placeableInWorld(boolean placeableInWorld) {
        this.placeableInWorld = placeableInWorld;
        return this;
    }

    public FluidBuilder disableAutomaticBucketRegistration() {
        this.automaticBucketRegistration = false;
        return this;
    }

    public FluidBuilder fillSound(String fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public FluidBuilder genericFillSound() {
        this.fillSound = "nyalib-fluid:item.bucket.fill";
        return this;
    }

    public FluidBuilder lavaFillSound() {
        this.fillSound = "nyalib-fluid:item.bucket.fill_lava";
        return this;
    }

    public FluidBuilder emptySound(String emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public FluidBuilder genericEmptySound() {
        this.emptySound = "nyalib-fluid:item.bucket.empty";
        return this;
    }

    public FluidBuilder lavaEmptySound() {
        this.emptySound = "nyalib-fluid:item.bucket.empty_lava";
        return this;
    }

    public FluidBuilder tickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public FluidBuilder canSwimIn(boolean canSwimIn) {
        this.canSwimIn = canSwimIn;
        return this;
    }

    public FluidBuilder movementSpeedMultiplier(double movementSpeedMultiplier) {
        this.movementSpeedMultiplier = movementSpeedMultiplier;
        return this;
    }

    public FluidBuilder willDrown(boolean willDrown) {
        this.willDrown = willDrown;
        return this;
    }

    public FluidBuilder lightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
        return this;
    }

    public FluidBuilder colorMultiplier(int colorMultiplier) {
        this.colorMultiplier = colorMultiplier;
        return this;
    }

    public Fluid build() {
        return this.build(Fluid::new);
    }

    public Fluid build(FluidFactory factory) {
        Fluid fluid;
        if (this.stillBlock != null && this.flowingBlock != null) {
            fluid = factory.create(this.identifier, this.stillBlock, this.flowingBlock);
        } else if (this.stillTexture != null && this.flowingTexture != null) {
            fluid = factory.create(this.identifier, null, null);
            if (this.overlayTexture == null) {
                this.overlayTexture = this.stillTexture;
            }
            if (this.mapColor == null) {
                this.mapColor = MapColorUtil.addMapColor((int)this.color);
            }
            FluidBlockManager.requestBlock(fluid, this.stillTexture, this.flowingTexture, this.overlayTexture, this.mapColor);
        } else {
            throw new IllegalStateException("Tried to build a Fluid that has not been initialized with blocks or textures");
        }
        if (this.color != null) {
            fluid.setColor(this.color);
        } else {
            NyaLib.LOGGER.warn("Fluid " + String.valueOf(this.identifier) + " has no color set!");
        }
        if (this.bucketSize != null) {
            fluid.setBucketSize(this.bucketSize);
        }
        if (this.bucketItem != null) {
            fluid.setBucketItem(this.bucketItem);
        }
        if (this.placeableInWorld != null) {
            fluid.setPlaceableInWorld(this.placeableInWorld);
        }
        if (this.automaticBucketRegistration == Boolean.FALSE) {
            fluid.disableAutomaticBucketRegistration();
        }
        if (this.fillSound != null) {
            fluid.setFillSound(this.fillSound);
        }
        if (this.emptySound != null) {
            fluid.setEmptySound(this.emptySound);
        }
        if (this.tickRate != null) {
            fluid.setTickRate(this.tickRate);
        }
        if (this.canSwimIn != null) {
            fluid.setCanSwimIn(this.canSwimIn);
        }
        if (this.movementSpeedMultiplier != null) {
            fluid.setMovementSpeedMultiplier(this.movementSpeedMultiplier);
        }
        if (this.willDrown != null) {
            fluid.setWillDrown(this.willDrown);
        }
        if (this.lightLevel != null) {
            fluid.setLightLevel(this.lightLevel);
        }
        if (this.colorMultiplier != null) {
            fluid.setColorMultiplier(this.colorMultiplier);
        }
        return fluid;
    }

    public static interface FluidFactory {
        public Fluid create(Identifier var1, class_17 var2, class_17 var3);
    }
}

