/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.init.fluid;

import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.block.JsonOverrideRegistry;
import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_124;
import net.minecraft.class_300;
import net.modificationstation.stationapi.api.client.event.color.item.ItemColorsRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.AfterBlockAndItemRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.ItemRegistryEvent;
import net.modificationstation.stationapi.api.item.ItemConvertible;
import net.modificationstation.stationapi.api.template.item.TemplateBucketItem;
import net.modificationstation.stationapi.api.util.Identifier;

public class ItemListener {
    public static HashMap<class_124, Fluid> bucketFluids;
    public String bucketItemJson = "{\n  \"parent\": \"nyalib-fluid:item/fluid_bucket\"\n}";

    @EventListener
    public void registerBuckets(ItemRegistryEvent event) {
        bucketFluids = new HashMap();
        for (Map.Entry<Identifier, Fluid> fluidEntry : FluidRegistry.getRegistry().entrySet()) {
            if (!fluidEntry.getValue().automaticBucketRegistrationEnabled()) continue;
            Identifier bucketIdentifier = fluidEntry.getKey().withSuffixedPath("_bucket");
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                JsonOverrideRegistry.registerItemModelOverride((Identifier)bucketIdentifier, (String)this.bucketItemJson);
            }
            class_124 bucket = new TemplateBucketItem(bucketIdentifier, fluidEntry.getValue().getBucketFluid().field_1915).setTranslationKey(bucketIdentifier);
            fluidEntry.getValue().setBucketItem(bucket);
            bucketFluids.put(bucket, fluidEntry.getValue());
        }
    }

    @EventListener
    public void assignFluidBuckets(AfterBlockAndItemRegisterEvent event) {
        for (Map.Entry<Identifier, Fluid> fluidEntry : FluidRegistry.getRegistry().entrySet()) {
            Fluid fluid = fluidEntry.getValue();
            if (fluid.getFluidBucketFactory() == null) continue;
            fluid.setBucketItem(fluid.getFluidBucketFactory().create(fluid));
        }
    }

    @EventListener
    public void registerColorProvider(ItemColorsRegisterEvent event) {
        for (Map.Entry<class_124, Fluid> bucketEntry : bucketFluids.entrySet()) {
            event.itemColors.register((stack, layer) -> layer == 1 ? ((Fluid)bucketEntry.getValue()).getColor() : 0xFFFFFF, new ItemConvertible[]{(ItemConvertible)bucketEntry.getKey()});
        }
    }

    public static void registerTranslations() {
        class_300 translationStorage = class_300.method_992();
        String bucketKey = translationStorage.method_993("item.nyalib.fluid_bucket");
        for (Map.Entry<class_124, Fluid> entry : bucketFluids.entrySet()) {
            class_124 bucket = entry.getKey();
            Fluid fluid = entry.getValue();
            translationStorage.field_1174.put(bucket.method_443() + ".name", translationStorage.method_994(bucketKey, new Object[]{fluid.getTranslatedName()}));
        }
    }
}

