package net.danygames2014.nyalib.init.fluid;

import net.danygames2014.nyalib.block.JsonOverrideRegistry;
import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_124;
import net.minecraft.class_300;
import net.modificationstation.stationapi.api.client.event.color.item.ItemColorsRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.AfterBlockAndItemRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.ItemRegistryEvent;
import net.modificationstation.stationapi.api.template.item.TemplateBucketItem;
import net.modificationstation.stationapi.api.util.Identifier;

import java.util.HashMap;

public class ItemListener {
    public static HashMap<class_124, Fluid> bucketFluids;

    @EventListener
    public void registerBuckets(ItemRegistryEvent event) {
        bucketFluids = new HashMap<>();

        for (var fluidEntry : FluidRegistry.getRegistry().entrySet()) {
            if (!fluidEntry.getValue().automaticBucketRegistrationEnabled()) {
                continue;
            }

            Identifier bucketIdentifier = fluidEntry.getKey().withSuffixedPath("_bucket");
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                JsonOverrideRegistry.registerItemModelOverride(bucketIdentifier, bucketItemJson);
            }
            
            class_124 bucket = new TemplateBucketItem(bucketIdentifier, fluidEntry.getValue().getBucketFluid().field_1915).setTranslationKey(bucketIdentifier);
            fluidEntry.getValue().setBucketItem(bucket);
            bucketFluids.put(bucket, fluidEntry.getValue());
        }
    }
    
    @EventListener
    public void assignFluidBuckets(AfterBlockAndItemRegisterEvent event) {
        for (var fluidEntry : FluidRegistry.getRegistry().entrySet()) {
            Fluid fluid = fluidEntry.getValue();
            if (fluid.getFluidBucketFactory() != null) {
                fluid.setBucketItem(fluid.getFluidBucketFactory().create(fluid));
            }
        }
    }

    @EventListener
    public void registerColorProvider(ItemColorsRegisterEvent event) {
        for (var bucketEntry : bucketFluids.entrySet()) {
            event.itemColors.register(
                    (stack, layer) -> layer == 1 ? bucketEntry.getValue().getColor() : 0xFFFFFF,
                    bucketEntry.getKey()
            );
        }

    }

    public static void registerTranslations() {
        class_300 translationStorage = class_300.method_992();
        String bucketKey = translationStorage.method_993("item.nyalib.fluid_bucket");

        for (var entry : bucketFluids.entrySet()) {
            class_124 bucket = entry.getKey();
            Fluid fluid = entry.getValue();

            translationStorage.field_1174.put(bucket.method_443() + ".name", translationStorage.method_994(bucketKey, fluid.getTranslatedName()));
        }
    }

    public String bucketItemJson = ("""
            {
              "parent": "nyalib-fluid:item/fluid_bucket"
            }"""
    );
}
