/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import java.awt.Color;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.fluid.FluidBucketFactory;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.danygames2014.nyalib.fluid.Fluids;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_57;
import net.minecraft.class_629;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class Fluid {
    private final Identifier identifier;
    private class_17 still;
    private class_17 flowing;
    private int bucketSize = 1000;
    private class_124 bucketItem;
    private FluidBucketFactory fluidBucketFactory;
    private boolean isPlaceableInWorld = true;
    private boolean automaticBucketRegistration = true;
    private String fillSound = null;
    private String emptySound = null;
    private int color = -1;
    private int lightLevel = 0;
    private int tickRate = 5;
    private boolean canSwimIn = true;
    private double movementSpeedMultiplier = 1.0;
    private boolean willDrown = true;
    private int colorMultiplier = 0xFFFFFF;

    public Fluid(Identifier identifier, class_17 still, class_17 flowing) {
        this.identifier = identifier;
        this.still = still;
        this.flowing = flowing;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public int getColor() {
        return this.color;
    }

    public Fluid setColor(int color) {
        this.color = color;
        return this;
    }

    public Fluid setColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public Fluid setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    @Nullable
    public class_124 getBucketItem() {
        return this.bucketItem;
    }

    public Fluid setBucketItem(class_124 bucketItem) {
        this.bucketItem = bucketItem;
        return this;
    }

    public FluidBucketFactory getFluidBucketFactory() {
        return this.fluidBucketFactory;
    }

    public Fluid setFluidBucketFactory(FluidBucketFactory fluidBucketFactory) {
        this.fluidBucketFactory = fluidBucketFactory;
        return this;
    }

    public class_17 getBucketFluid() {
        return this.flowing;
    }

    public boolean automaticBucketRegistrationEnabled() {
        return this.automaticBucketRegistration;
    }

    public Fluid disableAutomaticBucketRegistration() {
        this.automaticBucketRegistration = false;
        return this;
    }

    public boolean isPlaceableInWorld() {
        return this.isPlaceableInWorld;
    }

    public Fluid setPlaceableInWorld(boolean placeableInWorld) {
        this.isPlaceableInWorld = placeableInWorld;
        return this;
    }

    public String getFillSound() {
        return this.fillSound;
    }

    public Fluid setFillSound(String fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public String getEmptySound() {
        return this.emptySound;
    }

    public Fluid setEmptySound(String emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public class_17 getStillBlock() {
        return this.still;
    }

    public Fluid setStillBlock(class_17 still) {
        if (this.still != null) {
            NyaLib.LOGGER.warn("Tried to set a still block to the fluid " + String.valueOf(this.getIdentifier()) + ", but it was already set!");
            return this;
        }
        this.still = still;
        return this;
    }

    public class_17 getFlowingBlock() {
        return this.flowing;
    }

    public Fluid setFlowingBlock(class_17 flowing) {
        if (this.flowing != null) {
            NyaLib.LOGGER.warn("Tried to set a flowing block to the fluid " + String.valueOf(this.getIdentifier()) + ", but it was already set!");
            return this;
        }
        this.flowing = flowing;
        return this;
    }

    public class_15 getMaterial() {
        if (this.flowing != null) {
            return this.flowing.field_1900;
        }
        if (this.still != null) {
            return this.still.field_1900;
        }
        return Fluids.DEFAULT_FLUID_MATERIAL;
    }

    public int getLightLevel(BlockState state) {
        return this.lightLevel;
    }

    public Fluid setLightLevel(int lightLevel) {
        if (lightLevel < 0) {
            this.lightLevel = 0;
            return this;
        }
        if (lightLevel > 15) {
            this.lightLevel = 15;
            return this;
        }
        this.lightLevel = lightLevel;
        return this;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Fluid setTickRate(int tickRate) {
        if (tickRate < 0) {
            tickRate = 0;
        }
        this.tickRate = tickRate;
        return this;
    }

    public boolean canSwim(class_57 entity) {
        return this.canSwimIn;
    }

    public Fluid setCanSwimIn(boolean canSwimIn) {
        this.canSwimIn = canSwimIn;
        return this;
    }

    public double getMovementSpeedMultiplier(class_127 entity) {
        return this.movementSpeedMultiplier;
    }

    public Fluid setMovementSpeedMultiplier(double movementSpeedMultiplier) {
        this.movementSpeedMultiplier = movementSpeedMultiplier;
        return this;
    }

    public boolean willDrown(class_127 livingEntity) {
        return this.willDrown && !livingEntity.method_934();
    }

    public Fluid setWillDrown(boolean willDrown) {
        this.willDrown = willDrown;
        return this;
    }

    public int getColorMultiplier(class_14 blockView, int x, int y, int z) {
        return this.colorMultiplier;
    }

    public int setColorMultiplier(int colorMultiplier) {
        this.colorMultiplier = colorMultiplier;
        return this.colorMultiplier;
    }

    public String getTranslationKey() {
        return "fluid." + String.valueOf(this.identifier.namespace) + "." + this.identifier.path + ".name";
    }

    public String getTranslatedName() {
        return class_629.method_2049((String)this.getTranslationKey());
    }

    public String getTranslationKey(FluidStack fluidStack) {
        return this.getTranslationKey();
    }

    public String getTranslatedName(FluidStack fluidStack) {
        return this.getTranslatedName();
    }
}

