/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.minecraft.class_31;

public interface FluidHandlerItem {
    public boolean canExtractFluid(class_31 var1);

    public FluidStack extractFluid(class_31 var1, int var2, int var3);

    default public FluidStack extractFluid(class_31 thiz) {
        return this.extractFluid(thiz, Integer.MAX_VALUE);
    }

    default public FluidStack extractFluid(class_31 thiz, int amount) {
        for (int i = 0; i < this.getFluidSlots(thiz); ++i) {
            if (this.getFluid(thiz, i) == null) continue;
            return this.extractFluid(thiz, i, amount);
        }
        return null;
    }

    default public FluidStack extractFluid(class_31 thiz, Fluid fluid, int amount) {
        FluidStack currentStack = null;
        int remaining = amount;
        for (int i = 0; i < this.getFluidSlots(thiz) && remaining > 0; ++i) {
            FluidStack extractedStack;
            if (currentStack != null) {
                if (!this.getFluid(thiz, i).isFluidEqual(currentStack)) continue;
                extractedStack = this.extractFluid(thiz, i, remaining);
                remaining -= extractedStack.amount;
                currentStack.amount += extractedStack.amount;
                continue;
            }
            extractedStack = this.extractFluid(thiz, i, remaining);
            remaining -= extractedStack.amount;
            currentStack = extractedStack;
        }
        return currentStack;
    }

    public boolean canInsertFluid(class_31 var1);

    public FluidStack insertFluid(class_31 var1, FluidStack var2, int var3);

    public FluidStack insertFluid(class_31 var1, FluidStack var2);

    public FluidStack getFluid(class_31 var1, int var2);

    public boolean setFluid(class_31 var1, int var2, FluidStack var3);

    public int getFluidSlots(class_31 var1);

    public int getFluidCapacity(class_31 var1, int var2);

    default public int getRemainingFluidCapacity(class_31 thiz, int slot) {
        if (slot >= this.getFluidSlots(thiz)) {
            return 0;
        }
        if (this.getFluid(thiz, slot) == null) {
            return this.getFluidCapacity(thiz, slot);
        }
        return this.getFluidCapacity(thiz, slot) - this.getFluid((class_31)thiz, (int)slot).amount;
    }

    public FluidStack[] getFluids(class_31 var1);
}

