package net.danygames2014.nyalib.fluid;

import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_629;
import net.modificationstation.stationapi.api.util.Identifier;

import java.awt.*;


public final class Fluid {
    /**
     * The unique identifier of the fluid
     */
    private final Identifier identifier;
    /**
     * The in-world block representing the fluid in its still state
     */
    private final class_17 still;
    /**
     * The in-world block representing the fluid in its flowing state
     */
    private final class_17 flowing;
    /**
     * This determines how much of a fluid in mB does a bucket hold.
     * This will be used when a fluid is placed into the world or taken from it.
     */
    private int bucketSize = 1000;

    /**
     * Determines if the fluid is placeable in world
     */
    private boolean isPlaceableInWorld = true;

    /**
     * The sound that will be played when the bucket is filled
     */
    private String fillSound = null;

    /**
     * The sound the bucket will make when a bucket of this fluid is emptied
     */
    private String emptySound = null;

    /**
     * The color of the fluid, used for the bucket for the fluid.
     * This represents an ARGB color
     */
    private int color = 0xFFFFFFFF;

    public Fluid(Identifier identifier, class_17 still, class_17 flowing) {
        this.identifier = identifier;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid(Identifier identifier, class_17 still, class_17 flowing, int color) {
        this(identifier, still, flowing);
        this.color = color;
    }

    public Fluid(Identifier identifier, class_17 still, class_17 flowing, Color color) {
        this(identifier, still, flowing);
        this.color = color.getRGB();
    }

    // Identifier
    public Identifier getIdentifier() {
        return identifier;
    }

    // Fluid Color
    public int getColor() {
        return color;
    }

    public Fluid setColor(int color) {
        this.color = color;
        return this;
    }

    public Fluid setColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    // Buckets
    public int getBucketSize() {
        return bucketSize;
    }

    public Fluid setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public class_17 getBucketFluid() {
        return flowing;
    }

    // Bucket Behavior
    public boolean isPlaceableInWorld() {
        return isPlaceableInWorld;
    }

    public Fluid setPlaceableInWorld(boolean placeableInWorld) {
        this.isPlaceableInWorld = placeableInWorld;
        return this;
    }

    // Bucket Sound
    public String getFillSound() {
        if (fillSound == null) {
            if (getBucketFluid() != null && getBucketFluid().field_1900 == class_15.field_986) {
                return "nyalib-base:item.bucket.fill_lava";
            } else {
                return "nyalib-base:item.bucket.fill";
            }
        }

        return fillSound;
    }

    public Fluid setFillSound(String fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public String getEmptySound() {
        if (emptySound == null) {
            if (getBucketFluid() != null && getBucketFluid().field_1900 == class_15.field_986) {
                return "nyalib-base:item.bucket.empty_lava";
            } else {
                return "nyalib-base:item.bucket.empty";
            }
        }

        return emptySound;
    }

    public Fluid setEmptySound(String emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    // Blocks
    public class_17 getStillBlock() {
        return still;
    }

    public class_17 getFlowingBlock() {
        return flowing;
    }

    // Localization
    public String getTranslationKey() {
        return "fluid." + identifier.namespace + "." + identifier.path + ".name";
    }

    public String getTranslatedName() {
        return class_629.method_2049(getTranslationKey());
    }
}
