package net.danygames2014.nyalib.fluid;

import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;

@SuppressWarnings("unused")
public class FluidStack {
    /**
     * The fluid this stack contains
     */
    public Fluid fluid;
    /**
     * Amount in mB
     * 1000mB = 1B
     */
    public int amount;

    private FluidStack() {
    }

    private FluidStack(int amount) {
    }

    /**
     * Initializes a new FluidStack with the given fluid and amount
     *
     * @param fluid  The fluid to initialize the ItemStack with
     * @param amount The amount of the fluid in mB
     */
    public FluidStack(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public FluidStack(Identifier id) {
        this(id, 1000);
    }

    public FluidStack(Identifier id, int amount) {
        this.fluid = FluidRegistry.get(id);
        this.amount = amount;
    }

    public FluidStack(class_8 nbt) {
        this.readNbt(nbt);
    }

    public FluidStack copy() {
        return new FluidStack(this.fluid, this.amount);
    }

    /**
     * Initializes a new FluidStack with the given fluid and 1000mB
     *
     * @param fluid The fluid to initialize the ItemStack with
     */
    public FluidStack(Fluid fluid) {
        this(fluid, 1000);
    }

    public boolean isFluidEqual(FluidStack other) {
        if (other == null) {
            return false;
        }

        return other.fluid == this.fluid;
    }

    public static boolean areEqual(FluidStack left, FluidStack right) {
        if (left == null && right == null) {
            return true;
        } else {
            return left != null && left.equals(right);
        }
    }

    @SuppressWarnings("RedundantIfStatement")
    @Override
    public final boolean equals(Object other) {
        if (other instanceof FluidStack otherStack) {
            if (!isFluidEqual(otherStack)) {
                return false;
            }
            
            if (this.amount != otherStack.amount) {
                return false;
            }
            
            return true;
        }

        return false;
    }

    public class_8 writeNbt(class_8 nbt) {
        nbt.method_1019("fluid", this.fluid.getIdentifier().toString());
        nbt.method_1015("amount", this.amount);
        return nbt;
    }

    public void readNbt(class_8 nbt) {
        this.fluid = FluidRegistry.get(Identifier.of(nbt.method_1031("fluid")));
        this.amount = nbt.method_1027("amount");
    }

    public FluidStack fromNbt(class_8 nbt) {
        FluidStack stack = new FluidStack();

        stack.readNbt(nbt);

        if (stack.fluid != null) {
            return stack;
        } else {
            return null;
        }
    }

    @Override
    public String toString() {
        return "FluidStack { Fluid = " + fluid.getTranslatedName() + " | Amount = " + amount + "mB }";
    }
}
