/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import java.awt.Color;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_629;
import net.modificationstation.stationapi.api.util.Identifier;

public final class Fluid {
    private final Identifier identifier;
    private final class_17 still;
    private final class_17 flowing;
    private int bucketSize = 1000;
    private boolean isPlaceableInWorld = true;
    private String fillSound = null;
    private String emptySound = null;
    private int color = -1;

    public Fluid(Identifier identifier, class_17 still, class_17 flowing) {
        this.identifier = identifier;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid(Identifier identifier, class_17 still, class_17 flowing, int color) {
        this(identifier, still, flowing);
        this.color = color;
    }

    public Fluid(Identifier identifier, class_17 still, class_17 flowing, Color color) {
        this(identifier, still, flowing);
        this.color = color.getRGB();
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public int getColor() {
        return this.color;
    }

    public Fluid setColor(int color) {
        this.color = color;
        return this;
    }

    public Fluid setColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public Fluid setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public class_17 getBucketFluid() {
        return this.flowing;
    }

    public boolean isPlaceableInWorld() {
        return this.isPlaceableInWorld;
    }

    public Fluid setPlaceableInWorld(boolean placeableInWorld) {
        this.isPlaceableInWorld = placeableInWorld;
        return this;
    }

    public String getFillSound() {
        if (this.fillSound == null) {
            if (this.getBucketFluid() != null && this.getBucketFluid().field_1900 == class_15.field_986) {
                return "nyalib-base:item.bucket.fill_lava";
            }
            return "nyalib-base:item.bucket.fill";
        }
        return this.fillSound;
    }

    public Fluid setFillSound(String fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public String getEmptySound() {
        if (this.emptySound == null) {
            if (this.getBucketFluid() != null && this.getBucketFluid().field_1900 == class_15.field_986) {
                return "nyalib-base:item.bucket.empty_lava";
            }
            return "nyalib-base:item.bucket.empty";
        }
        return this.emptySound;
    }

    public Fluid setEmptySound(String emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public class_17 getStillBlock() {
        return this.still;
    }

    public class_17 getFlowingBlock() {
        return this.flowing;
    }

    public String getTranslationKey() {
        return "fluid." + String.valueOf(this.identifier.namespace) + "." + this.identifier.path + ".name";
    }

    public String getTranslatedName() {
        return class_629.method_2049((String)this.getTranslationKey());
    }
}

