/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.entity.player.PlayerHelper;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.SideUtil;
import org.jetbrains.annotations.NotNull;

public class FluidInventoryS2CPacket
extends class_169
implements ManagedPacket<FluidInventoryS2CPacket> {
    public static final PacketType<FluidInventoryS2CPacket> TYPE = PacketType.builder((boolean)true, (boolean)false, FluidInventoryS2CPacket::new).build();
    public int syncId;
    public FluidStack[] contents;
    private int size = 4;

    public FluidInventoryS2CPacket() {
    }

    public FluidInventoryS2CPacket(int syncId, ArrayList<FluidStack> stacks) {
        this.syncId = syncId;
        this.contents = new FluidStack[stacks.size()];
        for (int i = 0; i < stacks.size(); ++i) {
            FluidStack stack = stacks.get(i);
            this.contents[i] = stack == null ? null : stack.copy();
        }
    }

    public void method_806(DataInputStream stream) {
        try {
            this.syncId = stream.readInt();
            this.contents = new FluidStack[stream.readShort()];
            for (int i = 0; i < this.contents.length; ++i) {
                if (!stream.readBoolean()) continue;
                this.contents[i] = new FluidStack(FluidRegistry.get(Identifier.of((String)stream.readUTF())), stream.readInt());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();
            stream.writeInt(this.syncId);
            stream.writeShort(this.contents.length);
            for (int i = 0; i < this.contents.length; ++i) {
                if (this.contents[i] == null) {
                    stream.writeBoolean(false);
                    continue;
                }
                stream.writeBoolean(true);
                stream.writeUTF(this.contents[i].fluid.getIdentifier().toString());
                stream.writeInt(this.contents[i].amount);
            }
            this.size = stream.size() - initialStreamSize;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 networkHandler) {
        SideUtil.run(() -> this.handleClient(networkHandler), () -> {});
    }

    @Environment(value=EnvType.CLIENT)
    private void handleClient(class_240 networkHandler) {
        class_54 player = PlayerHelper.getPlayerFromPacketHandler((class_240)networkHandler);
        if (this.syncId == 0) {
            player.field_520.updateFluidSlotStacksClient(this.contents);
        } else if (this.syncId == player.field_521.field_2735) {
            player.field_521.updateFluidSlotStacksClient(this.contents);
        }
    }

    public int method_798() {
        return 0;
    }

    @NotNull
    public PacketType<FluidInventoryS2CPacket> getType() {
        return TYPE;
    }
}

