/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.mixin.fluid;

import net.danygames2014.nyalib.block.FlowingFluidBlock;
import net.danygames2014.nyalib.block.FluidBlockTextureHolder;
import net.danygames2014.nyalib.block.StillFluidBlock;
import net.minecraft.class_17;
import net.minecraft.class_189;
import net.minecraft.class_556;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.client.StationRenderAPI;
import net.modificationstation.stationapi.api.client.texture.atlas.Atlas;
import net.modificationstation.stationapi.api.client.texture.atlas.Atlases;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_556.class})
public abstract class HeldItemRendererMixin {
    @Shadow
    private Minecraft field_2401;
    @Unique
    int atlasTextureId = -1;

    @Inject(method={"method_1864(F)V"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glEnable(I)V", ordinal=0, shift=At.Shift.BEFORE)})
    public void renderFluidOverlay(float tickDelta, CallbackInfo ci) {
        int x = class_189.method_645((double)this.field_2401.field_2806.field_1600);
        int y = class_189.method_645((double)this.field_2401.field_2806.field_1601);
        int z = class_189.method_645((double)this.field_2401.field_2806.field_1602);
        class_17 block = this.field_2401.field_2804.getBlockState(x, y, z).getBlock();
        StillFluidBlock stillBlock = null;
        if (block instanceof StillFluidBlock) {
            StillFluidBlock stillFluidBlock;
            stillBlock = stillFluidBlock = (StillFluidBlock)block;
        } else if (block instanceof FlowingFluidBlock) {
            FlowingFluidBlock flowingFluidBlock = (FlowingFluidBlock)block;
            class_17 class_172 = flowingFluidBlock.fluid.getStillBlock();
            if (class_172 instanceof StillFluidBlock) {
                StillFluidBlock stillFluidBlock;
                stillBlock = stillFluidBlock = (StillFluidBlock)class_172;
            }
        }
        if (stillBlock == null) {
            return;
        }
        if (!this.field_2401.field_2806.method_1328(stillBlock.field_1900)) {
            return;
        }
        if (stillBlock.textureHolder.overlaySpriteId != -1) {
            this.renderWrappedOverlay(tickDelta, stillBlock.textureHolder);
        }
    }

    @Unique
    private void renderStaticOverlay(float tickDelta, int textureId) {
        Atlas.Sprite tex = Atlases.getTerrain().getTexture(textureId);
        class_67 tessellator = class_67.field_2054;
        float brightness = this.field_2401.field_2806.method_1394(tickDelta);
        if (this.atlasTextureId == -1) {
            this.atlasTextureId = StationRenderAPI.getBakedModelManager().getAtlas(Atlases.GAME_ATLAS_TEXTURE).getGlId();
        }
        GL11.glBindTexture((int)3553, (int)this.atlasTextureId);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        tessellator.method_1695();
        tessellator.method_1688(-1.0, -1.0, -0.5, tex.getEndU(), tex.getEndV());
        tessellator.method_1688(1.0, -1.0, -0.5, tex.getStartU(), tex.getEndV());
        tessellator.method_1688(1.0, 1.0, -0.5, tex.getStartU(), tex.getStartV());
        tessellator.method_1688(-1.0, 1.0, -0.5, tex.getEndU(), tex.getStartV());
        tessellator.method_1685();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    @Unique
    public void renderWrappedOverlay(float tickDelta, FluidBlockTextureHolder textureHolder) {
        class_67 tessellator = class_67.field_2054;
        int textureWidth = textureHolder.overlayTextureWidth;
        int textureHeight = textureHolder.overlayTextureHeight;
        int windowSize = 32;
        float yaw = -this.field_2401.field_2806.field_1606 / (float)(textureWidth * 16);
        float pitch = this.field_2401.field_2806.field_1607 / (float)(textureHeight * 16);
        float windowU = (float)windowSize / (float)textureWidth;
        float windowV = (float)windowSize / (float)textureHeight;
        float uMin = 0.0f + yaw;
        float uMax = windowU + yaw;
        float vMin = 0.0f + pitch;
        float vMax = windowV + pitch;
        float brightness = this.field_2401.field_2806.method_1394(tickDelta);
        GL11.glBindTexture((int)3553, (int)textureHolder.getOverlayTextureId());
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glPushMatrix();
        tessellator.method_1695();
        tessellator.method_1688(-1.0, -1.0, -0.5, (double)uMax, (double)vMax);
        tessellator.method_1688(1.0, -1.0, -0.5, (double)uMin, (double)vMax);
        tessellator.method_1688(1.0, 1.0, -0.5, (double)uMin, (double)vMin);
        tessellator.method_1688(-1.0, 1.0, -0.5, (double)uMax, (double)vMin);
        tessellator.method_1685();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }
}

