package net.danygames2014.nyalib.block;

import net.danygames2014.nyalib.fluid.Fluid;
import net.minecraft.class_15;
import net.modificationstation.stationapi.api.template.block.TemplateStillLiquidBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class StillFluidBlock extends TemplateStillLiquidBlock {
    public final Fluid fluid;
    public FluidBlockTextureHolder textureHolder;
    
    public StillFluidBlock(Identifier identifier, class_15 material, Fluid fluid) {
        super(identifier, material);
        this.fluid = fluid;
        this.setTranslationKey(identifier);
    }

    // Tick Rate
    @Override
    public int method_1565() {
        return fluid.getTickRate();
    }

    // Rendering
    @Override
    public int method_1627(int side, int meta) {
        if (textureHolder == null) {
            return 0;
        }

        if (meta == 0 && (side == 0 || side == 1)) {
            return textureHolder.getStillTextureId();
        }

        return super.method_1627(side, meta);
    }

    public int method_1607(int side) {
        if (textureHolder == null) {
            return 0;
        }
        
        if (side == 0 || side == 1) {
            return textureHolder.getStillTextureId();
        }
        
        return textureHolder.getFlowingTextureId();
    }
}
