/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import java.awt.Color;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.block.FluidBlockManager;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.danygames2014.nyalib.fluid.Fluids;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_259;
import net.minecraft.class_57;
import net.minecraft.class_629;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class Fluid {
    private final Identifier identifier;
    private class_17 still;
    private class_17 flowing;
    private int bucketSize = 1000;
    private class_124 bucketItem;
    private boolean isPlaceableInWorld = true;
    private boolean automaticBucketRegistration = true;
    private String fillSound = null;
    private String emptySound = null;
    private int color = -1;
    private int tickRate = 5;
    private boolean canSwimIn = true;
    private double swimSpeedMultiplier = 1.0;

    public Fluid(Identifier identifier, class_17 still, class_17 flowing) {
        this.identifier = identifier;
        this.still = still;
        this.flowing = flowing;
    }

    public Fluid(Identifier identifier, class_17 still, class_17 flowing, int color) {
        this(identifier, still, flowing);
        this.setColor(color);
    }

    public Fluid(Identifier identifier, class_17 still, class_17 flowing, Color color) {
        this(identifier, still, flowing);
        this.setColor(color);
    }

    public Fluid(Identifier identifier, Identifier stillTexture, Identifier flowingTexture, Identifier overlayTexture, class_259 mapColor, int color) {
        this(identifier, null, null);
        this.setColor(color);
        FluidBlockManager.requestBlock(this, stillTexture, flowingTexture, overlayTexture, mapColor);
    }

    public Fluid(Identifier identifier, Identifier stillTexture, Identifier flowingTexture, Identifier overlayTexture, int color) {
        this(identifier, stillTexture, flowingTexture, overlayTexture, Fluids.DEFAULT_FLUID_MATERIAL.field_973, color);
    }

    public Fluid(Identifier identifier, Identifier stillTexture, Identifier flowingTexture, class_259 mapColor, int color) {
        this(identifier, stillTexture, flowingTexture, stillTexture, mapColor, color);
    }

    public Fluid(Identifier identifier, Identifier stillTexture, Identifier flowingTexture, int color) {
        this(identifier, stillTexture, flowingTexture, stillTexture, Fluids.DEFAULT_FLUID_MATERIAL.field_973, color);
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public int getColor() {
        return this.color;
    }

    public Fluid setColor(int color) {
        this.color = color;
        return this;
    }

    public Fluid setColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public Fluid setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    @Nullable
    public class_124 getBucketItem() {
        return this.bucketItem;
    }

    public Fluid setBucketItem(class_124 bucketItem) {
        this.bucketItem = bucketItem;
        return this;
    }

    public class_17 getBucketFluid() {
        return this.flowing;
    }

    public boolean automaticBucketRegistrationEnabled() {
        return this.automaticBucketRegistration;
    }

    public Fluid disableAutomaticBucketRegistration() {
        this.automaticBucketRegistration = false;
        return this;
    }

    public boolean isPlaceableInWorld() {
        return this.isPlaceableInWorld;
    }

    public Fluid setPlaceableInWorld(boolean placeableInWorld) {
        this.isPlaceableInWorld = placeableInWorld;
        return this;
    }

    public String getFillSound() {
        if (this.fillSound == null) {
            if (this.getBucketFluid() != null && this.getBucketFluid().field_1900 == class_15.field_986) {
                return "nyalib-fluid:item.bucket.fill_lava";
            }
            return "nyalib-fluid:item.bucket.fill";
        }
        return this.fillSound;
    }

    public Fluid setFillSound(String fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public String getEmptySound() {
        if (this.emptySound == null) {
            if (this.getBucketFluid() != null && this.getBucketFluid().field_1900 == class_15.field_986) {
                return "nyalib-fluid:item.bucket.empty_lava";
            }
            return "nyalib-fluid:item.bucket.empty";
        }
        return this.emptySound;
    }

    public Fluid setEmptySound(String emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public class_17 getStillBlock() {
        return this.still;
    }

    public Fluid setStillBlock(class_17 still) {
        if (this.still != null) {
            NyaLib.LOGGER.warn("Tried to set a still block to the fluid " + String.valueOf(this.getIdentifier()) + ", but it was already set!");
            return null;
        }
        this.still = still;
        return this;
    }

    public class_17 getFlowingBlock() {
        return this.flowing;
    }

    public Fluid setFlowingBlock(class_17 flowing) {
        if (this.flowing != null) {
            NyaLib.LOGGER.warn("Tried to set a flowing block to the fluid " + String.valueOf(this.getIdentifier()) + ", but it was already set!");
            return null;
        }
        this.flowing = flowing;
        return this;
    }

    public class_15 getMaterial() {
        if (this.flowing != null) {
            return this.flowing.field_1900;
        }
        if (this.still != null) {
            return this.still.field_1900;
        }
        return Fluids.DEFAULT_FLUID_MATERIAL;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public Fluid setTickRate(int tickRate) {
        if (tickRate < 0) {
            tickRate = 0;
        }
        this.tickRate = tickRate;
        return this;
    }

    public boolean canSwim(class_57 entity) {
        return this.canSwimIn;
    }

    public Fluid setCanSwimIn(boolean canSwimIn) {
        this.canSwimIn = canSwimIn;
        return this;
    }

    public double getMovementSpeedMultiplier(class_127 entity) {
        return this.swimSpeedMultiplier;
    }

    public Fluid setMovementSpeedMultiplier(double movementSpeedMultiplier) {
        this.swimSpeedMultiplier = movementSpeedMultiplier;
        return this;
    }

    public String getTranslationKey() {
        return "fluid." + String.valueOf(this.identifier.namespace) + "." + this.identifier.path + ".name";
    }

    public String getTranslatedName() {
        return class_629.method_2049((String)this.getTranslationKey());
    }

    public String getTranslationKey(FluidStack fluidStack) {
        return this.getTranslationKey();
    }

    public String getTranslatedName(FluidStack fluidStack) {
        return this.getTranslatedName();
    }
}

