/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidCapable;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public interface FluidHandler
extends FluidCapable {
    public boolean canExtractFluid(@Nullable Direction var1);

    public FluidStack extractFluid(int var1, int var2, @Nullable Direction var3);

    default public FluidStack extractFluid(@Nullable Direction direction) {
        return this.extractFluid(Integer.MAX_VALUE, direction);
    }

    default public FluidStack extractFluid(int amount, @Nullable Direction direction) {
        for (int i = 0; i < this.getFluidSlots(direction); ++i) {
            if (this.getFluid(i, direction) == null) continue;
            return this.extractFluid(i, amount, direction);
        }
        return null;
    }

    default public FluidStack extractFluid(Fluid fluid, int amount, @Nullable Direction direction) {
        FluidStack currentStack = null;
        int remaining = amount;
        for (int i = 0; i < this.getFluidSlots(direction) && remaining > 0; ++i) {
            FluidStack extractedStack;
            if (currentStack != null) {
                if (!this.getFluid(i, direction).isFluidEqual(currentStack)) continue;
                extractedStack = this.extractFluid(i, remaining, direction);
                remaining -= extractedStack.amount;
                currentStack.amount += extractedStack.amount;
                continue;
            }
            extractedStack = this.extractFluid(i, remaining, direction);
            remaining -= extractedStack.amount;
            currentStack = extractedStack;
        }
        return currentStack;
    }

    public boolean canInsertFluid(@Nullable Direction var1);

    public FluidStack insertFluid(FluidStack var1, int var2, @Nullable Direction var3);

    public FluidStack insertFluid(FluidStack var1, @Nullable Direction var2);

    public FluidStack getFluid(int var1, @Nullable Direction var2);

    public boolean setFluid(int var1, FluidStack var2, @Nullable Direction var3);

    public int getFluidSlots(@Nullable Direction var1);

    public int getFluidCapacity(int var1, @Nullable Direction var2);

    default public int getRemainingFluidCapacity(int slot, @Nullable Direction direction) {
        if (slot >= this.getFluidSlots(direction)) {
            return 0;
        }
        if (this.getFluid(slot, direction) == null) {
            return this.getFluidCapacity(slot, direction);
        }
        return this.getFluidCapacity(slot, direction) - this.getFluid((int)slot, (Direction)direction).amount;
    }

    public FluidStack[] getFluids(@Nullable Direction var1);
}

