/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import net.danygames2014.nyalib.fluid.Fluid;
import net.danygames2014.nyalib.fluid.FluidStack;

public interface FluidHandlerEntity {
    public boolean canExtractFluid();

    public FluidStack extractFluid(int var1, int var2);

    default public FluidStack extractFluid() {
        return this.extractFluid(Integer.MAX_VALUE);
    }

    default public FluidStack extractFluid(int amount) {
        for (int i = 0; i < this.getFluidSlots(); ++i) {
            if (this.getFluid(i) == null) continue;
            return this.extractFluid(i, amount);
        }
        return null;
    }

    default public FluidStack extractFluid(Fluid fluid, int amount) {
        FluidStack currentStack = null;
        int remaining = amount;
        for (int i = 0; i < this.getFluidSlots() && remaining > 0; ++i) {
            FluidStack extractedStack;
            if (currentStack != null) {
                if (!this.getFluid(i).isFluidEqual(currentStack)) continue;
                extractedStack = this.extractFluid(i, remaining);
                remaining -= extractedStack.amount;
                currentStack.amount += extractedStack.amount;
                continue;
            }
            extractedStack = this.extractFluid(i, remaining);
            remaining -= extractedStack.amount;
            currentStack = extractedStack;
        }
        return currentStack;
    }

    public boolean canInsertFluid();

    public FluidStack insertFluid(FluidStack var1, int var2);

    public FluidStack insertFluid(FluidStack var1);

    public FluidStack getFluid(int var1);

    public boolean setFluid(int var1, FluidStack var2);

    public int getFluidSlots();

    public int getFluidCapacity(int var1);

    default public int getRemainingFluidCapacity(int slot) {
        if (slot >= this.getFluidSlots()) {
            return 0;
        }
        if (this.getFluid(slot) == null) {
            return this.getFluidCapacity(slot);
        }
        return this.getFluidCapacity(slot) - this.getFluid((int)slot).amount;
    }

    public FluidStack[] getFluids();
}

