/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import net.danygames2014.nyalib.fluid.FluidHandler;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class FluidSlot {
    private final int index;
    private final FluidHandler handler;
    public int id;
    public int x;
    public int y;

    public FluidSlot(FluidHandler handler, int index, int x, int y) {
        this.handler = handler;
        this.index = index;
        this.x = x;
        this.y = y;
    }

    public FluidStack getStack() {
        return this.handler.getFluid(this.index, null);
    }

    public boolean hasStack() {
        return this.getStack() != null;
    }

    public void setStack(FluidStack fluidStack) {
        this.handler.setFluid(this.index, fluidStack, null);
        this.markDirty();
    }

    public FluidStack takeStack(int amount) {
        return this.handler.extractFluid(this.index, amount, null);
    }

    public int getFluidAmount() {
        return this.handler.getFluid((int)this.index, null).amount;
    }

    public void setFluidAmount(int amount) {
        this.handler.getFluid((int)this.index, null).amount = Math.max(0, Math.min(this.getMaxFluidAmount(), amount));
    }

    public int getMaxFluidAmount() {
        return this.handler.getFluidCapacity(this.index, null);
    }

    public FluidHandler getHandler() {
        return this.handler;
    }

    public boolean canInsert(FluidStack fluidStack) {
        return true;
    }

    public void markDirty() {
    }

    public boolean equals(FluidHandler otherHandler, int otherIndex) {
        return otherHandler == this.handler && otherIndex == this.index;
    }

    public void onTakeFluid(FluidStack fluidStack) {
        this.markDirty();
    }

    @Environment(value=EnvType.CLIENT)
    public int getBackgroundTextureId() {
        return -1;
    }
}

