/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.fluid.FluidRegistry;
import net.danygames2014.nyalib.fluid.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.entity.player.PlayerHelper;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.SideUtil;
import org.jetbrains.annotations.NotNull;

public class ScreenHandlerFluidSlotUpdateS2CPacket
extends class_169
implements ManagedPacket<ScreenHandlerFluidSlotUpdateS2CPacket> {
    public static final PacketType<ScreenHandlerFluidSlotUpdateS2CPacket> TYPE = PacketType.builder((boolean)true, (boolean)false, ScreenHandlerFluidSlotUpdateS2CPacket::new).build();
    public int syncId;
    public int slot;
    public FluidStack stack;
    private int size = 10;

    public ScreenHandlerFluidSlotUpdateS2CPacket() {
    }

    public ScreenHandlerFluidSlotUpdateS2CPacket(int syncId, int slot, FluidStack stack) {
        this.syncId = syncId;
        this.slot = slot;
        this.stack = stack == null ? stack : stack.copy();
    }

    public void method_806(DataInputStream stream) {
        try {
            this.syncId = stream.readInt();
            this.slot = stream.readInt();
            String fluidIdentifier = stream.readUTF();
            if (!fluidIdentifier.isEmpty()) {
                int amount = stream.readInt();
                this.stack = new FluidStack(FluidRegistry.get(Identifier.of((String)fluidIdentifier)), amount);
            } else {
                this.stack = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            int initialStreamSize = stream.size();
            stream.writeInt(this.syncId);
            stream.writeInt(this.slot);
            if (this.stack == null) {
                stream.writeUTF("");
            } else {
                stream.writeUTF(this.stack.fluid.getIdentifier().toString());
                stream.writeInt(this.stack.amount);
            }
            this.size = stream.size() - initialStreamSize;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 networkHandler) {
        SideUtil.run(() -> this.handleClient(networkHandler), () -> {});
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient(class_240 networkHandler) {
        class_54 player = PlayerHelper.getPlayerFromPacketHandler((class_240)networkHandler);
        switch (this.syncId) {
            case -1: {
                NyaLib.LOGGER.error("Encountered an unknown syncId in ScreenHandlerFluidSlotUpdateS2CPacket: {}", (Object)this.syncId);
                break;
            }
            case 0: {
                player.field_520.setFluidStackInSlotClient(this.slot, this.stack);
                break;
            }
            default: {
                if (this.syncId != player.field_521.field_2735) break;
                player.field_521.setFluidStackInSlotClient(this.slot, this.stack);
            }
        }
    }

    public int method_798() {
        return this.size;
    }

    @NotNull
    public PacketType<ScreenHandlerFluidSlotUpdateS2CPacket> getType() {
        return TYPE;
    }
}

