package net.danygames2014.nyalib.capability.block.itemhandler;

import net.minecraft.class_124;
import net.minecraft.class_134;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("DuplicatedCode")
class ItemHandlerInventoryBlockCapability extends ItemHandlerBlockCapability {
    private final class_134 inventory;

    public ItemHandlerInventoryBlockCapability(class_134 inventory) {
        this.inventory = inventory;
    }

    @Override
    public boolean canConnectItem(Direction side) {
        return true;
    }

    @Override
    public boolean canExtractItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 extractItem(@Nullable Direction side) {
        return extractItem(Integer.MAX_VALUE, side);
    }

    @Override
    public class_31 extractItem(int amount, @Nullable Direction side) {
        for (int i = 0; i < getItemSlots(side); i++) {
            if (getItem(i, side) != null) {
                return extractItem(i, amount, side);
            }
        }
        return null;
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction side) {
        if (slot >= getItemSlots(side) || slot < 0) {
            return null;
        }

        return inventory.method_949(slot, amount);
    }

    @Override
    public class_31 extractItem(class_124 item, int amount, @Nullable Direction side) {
        return extractItem(item, -1, amount, side);
    }

    @Override
    public class_31 extractItem(class_124 item, int meta, int amount, @Nullable Direction side) {
        class_31 currentStack = null;
        int remaining = amount;

        for (int i = 0; i < getItemSlots(side); i++) {
            if (remaining <= 0) {
                break;
            }

            if (currentStack != null) {
                if (this.getItem(i, side).method_702(currentStack)) {
                    class_31 extractedStack = extractItem(i, remaining, side);
                    remaining -= extractedStack.field_751;
                    currentStack.field_751 += extractedStack.field_751;
                }
            } else {
                if (getItem(i, side).isOf(item) && (meta == -1 || getItem(i, side).method_722() == meta)) {
                    class_31 extractedStack = extractItem(i, remaining, side);
                    remaining -= extractedStack.field_751;
                    currentStack = extractedStack;
                }
            }
        }

        return currentStack;
    }

    @Override
    public boolean canInsertItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction side) {
        if (slot >= getItemSlots(side) || slot < 0) {
            return stack;
        }

        class_31 slotStack;

        slotStack = inventory.method_954(slot);

        if (slotStack == null) {
            inventory.method_950(slot, stack);
            return null;
        }

        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);

            slotStack.field_751 += addedCount;

            if (addedCount >= stack.field_751) {
                return null;
            } else {
                return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction side) {
        class_31 insertedStack = stack.method_724();

        for (int i = 0; i < this.getItemSlots(side); ++i) {
            insertedStack = insertItem(insertedStack, i, side);
            if (insertedStack == null) {
                return insertedStack;
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItem(int slot, @Nullable Direction side) {
        if (slot >= getItemSlots(side) || slot < 0) {
            return null;
        }
        
        return inventory.method_954(slot);
    }

    @Override
    public boolean setItem(class_31 stack, int slot, @Nullable Direction side) {
        if (slot >= getItemSlots(side) || slot < 0) {
            return false;
        }

        inventory.method_950(slot, stack);
        return true;
    }

    @Override
    public int getItemSlots(@Nullable Direction side) {
        return inventory.method_948();
    }

    @Override
    public class_31[] getInventory(@Nullable Direction side) {
        class_31[] stacks = new class_31[inventory.method_948()];

        for (int i = 0; i < inventory.method_948(); i++) {
            stacks[i] = inventory.method_954(i);
        }

        return stacks;
    }
}
