/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.capability.block.itemhandler;

import net.danygames2014.nyalib.capability.block.itemhandler.ItemHandlerBlockCapability;
import net.minecraft.class_124;
import net.minecraft.class_134;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

class ItemHandlerInventoryBlockCapability
extends ItemHandlerBlockCapability {
    private final class_134 inventory;

    public ItemHandlerInventoryBlockCapability(class_134 inventory) {
        this.inventory = inventory;
    }

    @Override
    public boolean canConnectItem(Direction side) {
        return true;
    }

    @Override
    public boolean canExtractItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 extractItem(@Nullable Direction side) {
        return this.extractItem(Integer.MAX_VALUE, side);
    }

    @Override
    public class_31 extractItem(int amount, @Nullable Direction side) {
        for (int i = 0; i < this.getItemSlots(side); ++i) {
            if (this.getItem(i, side) == null) continue;
            return this.extractItem(i, amount, side);
        }
        return null;
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction side) {
        if (slot >= this.getItemSlots(side) || slot < 0) {
            return null;
        }
        return this.inventory.method_949(slot, amount);
    }

    @Override
    public class_31 extractItem(class_124 item, int amount, @Nullable Direction side) {
        return this.extractItem(item, -1, amount, side);
    }

    @Override
    public class_31 extractItem(class_124 item, int meta, int amount, @Nullable Direction side) {
        class_31 currentStack = null;
        int remaining = amount;
        for (int i = 0; i < this.getItemSlots(side) && remaining > 0; ++i) {
            class_31 extractedStack;
            if (currentStack != null) {
                if (!this.getItem(i, side).method_702(currentStack)) continue;
                extractedStack = this.extractItem(i, remaining, side);
                remaining -= extractedStack.field_751;
                currentStack.field_751 += extractedStack.field_751;
                continue;
            }
            if (!this.getItem(i, side).isOf(item) || meta != -1 && this.getItem(i, side).method_722() != meta) continue;
            extractedStack = this.extractItem(i, remaining, side);
            remaining -= extractedStack.field_751;
            currentStack = extractedStack;
        }
        return currentStack;
    }

    @Override
    public boolean canInsertItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction side) {
        if (slot >= this.getItemSlots(side) || slot < 0) {
            return stack;
        }
        class_31 slotStack = this.inventory.method_954(slot);
        if (slotStack == null) {
            this.inventory.method_950(slot, stack);
            return null;
        }
        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);
            slotStack.field_751 += addedCount;
            if (addedCount >= stack.field_751) {
                return null;
            }
            return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
        }
        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction side) {
        class_31 insertedStack = stack.method_724();
        for (int i = 0; i < this.getItemSlots(side); ++i) {
            if ((insertedStack = this.insertItem(insertedStack, i, side)) != null) continue;
            return insertedStack;
        }
        return insertedStack;
    }

    @Override
    public class_31 getItem(int slot, @Nullable Direction side) {
        if (slot >= this.getItemSlots(side) || slot < 0) {
            return null;
        }
        return this.inventory.method_954(slot);
    }

    @Override
    public boolean setItem(class_31 stack, int slot, @Nullable Direction side) {
        if (slot >= this.getItemSlots(side) || slot < 0) {
            return false;
        }
        this.inventory.method_950(slot, stack);
        return true;
    }

    @Override
    public int getItemSlots(@Nullable Direction side) {
        return this.inventory.method_948();
    }

    @Override
    public class_31[] getInventory(@Nullable Direction side) {
        class_31[] stacks = new class_31[this.inventory.method_948()];
        for (int i = 0; i < this.inventory.method_948(); ++i) {
            stacks[i] = this.inventory.method_954(i);
        }
        return stacks;
    }
}

