/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.capability.entity.itemhandler;

import java.util.ArrayList;
import net.danygames2014.nyalib.capability.entity.itemhandler.ItemHandlerEntityCapability;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.minecraft.class_54;

class ItemHandlerPlayerEntityCapability
extends ItemHandlerEntityCapability {
    private final class_54 player;

    public ItemHandlerPlayerEntityCapability(class_54 player) {
        this.player = player;
    }

    @Override
    public boolean canExtractItem() {
        return true;
    }

    @Override
    public class_31 extractItem() {
        return this.extractItem(Integer.MAX_VALUE);
    }

    @Override
    public class_31 extractItem(int amount) {
        for (int i = 0; i < this.getItemSlots(); ++i) {
            if (this.getItem(i) == null) continue;
            return this.extractItem(i, amount);
        }
        return null;
    }

    @Override
    public class_31 extractItem(int slot, int amount) {
        if (slot >= this.getItemSlots() || slot < 0) {
            return null;
        }
        return this.player.field_519.method_949(slot, amount);
    }

    @Override
    public class_31 extractItem(class_124 item, int amount) {
        return this.extractItem(item, -1, amount);
    }

    @Override
    public class_31 extractItem(class_124 item, int meta, int amount) {
        class_31 currentStack = null;
        int remaining = amount;
        for (int i = 0; i < this.getItemSlots() && remaining > 0; ++i) {
            class_31 extractedStack;
            if (currentStack != null) {
                if (!this.getItem(i).method_702(currentStack)) continue;
                extractedStack = this.extractItem(i, remaining);
                remaining -= extractedStack.field_751;
                currentStack.field_751 += extractedStack.field_751;
                continue;
            }
            if (!this.getItem(i).isOf(item) || meta != -1 && this.getItem(i).method_722() != meta) continue;
            extractedStack = this.extractItem(i, remaining);
            remaining -= extractedStack.field_751;
            currentStack = extractedStack;
        }
        return currentStack;
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot) {
        if (slot >= this.getItemSlots() || slot < 0) {
            return stack;
        }
        if (this.player.field_519.method_954(slot) == null) {
            if (stack.field_751 <= this.player.field_519.method_953()) {
                this.player.field_519.method_950(slot, stack);
                return null;
            }
            if (stack.field_751 > this.player.field_519.method_953()) {
                this.player.field_519.method_950(slot, stack);
                class_31 remainderStack = stack.method_724();
                remainderStack.field_751 = stack.field_751 - this.player.field_519.method_953();
                return remainderStack;
            }
        } else {
            class_31 existingStack = this.player.field_519.method_954(slot);
            if (existingStack.method_702(stack)) {
                int freeSpace = this.player.field_519.method_953() - existingStack.field_751;
                existingStack.field_751 += stack.field_751;
                this.player.field_519.method_950(slot, existingStack);
                if (freeSpace >= stack.field_751) {
                    return null;
                }
                class_31 remainderStack = stack.method_724();
                remainderStack.field_751 = stack.field_751 - freeSpace;
                return remainderStack;
            }
        }
        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack) {
        class_31 insertedStack = stack.method_724();
        for (int i = 0; i < this.player.field_519.method_948(); ++i) {
            if ((insertedStack = this.insertItem(insertedStack, i)) != null) continue;
            return null;
        }
        return insertedStack;
    }

    @Override
    public class_31 getItem(int slot) {
        if (slot >= this.getItemSlots() || slot < 0) {
            return null;
        }
        return this.player.field_519.method_954(slot);
    }

    @Override
    public boolean setItem(class_31 stack, int slot) {
        if (slot >= this.getItemSlots() || slot < 0) {
            return false;
        }
        this.player.field_519.method_950(slot, stack);
        return true;
    }

    @Override
    public int getItemSlots() {
        return this.player.field_519.method_948();
    }

    @Override
    public class_31[] getInventory() {
        ArrayList<class_31> inventory = new ArrayList<class_31>(this.player.field_519.method_948());
        for (int i = 0; i < this.player.field_519.method_948(); ++i) {
            inventory.add(this.player.field_519.method_954(i));
        }
        return inventory.toArray(new class_31[0]);
    }
}

