package net.danygames2014.nyalib.capability.item.itemhandler;

import net.danygames2014.nyalib.capability.item.ItemCapability;
import net.minecraft.class_124;
import net.minecraft.class_31;

@SuppressWarnings("unused")
public abstract class ItemHandlerItemCapability extends ItemCapability {
    /**
     * Check if the item supports extracting items, if this returns false there
     * should be no point in trying to use any <code>extractItem</code> method.
     *
     * @return <code>true</code> if the item supports item extraction
     */
    public abstract boolean canExtractItem();

    /**
     * Extract any item from any slot
     *
     * @return The extracted ItemStack, <code>null</code> if nothing is extracted
     */
    public abstract class_31 extractItem();

    /**
     * Extract a specified amount of any item from any slot
     *
     * @param amount The amount of items to extract (can be larger than the maximum stack size)
     * @return The extracted ItemStack, <code>null</code> if nothing is extracted
     */
    public abstract class_31 extractItem(int amount);

    /**
     * Extract an item in the given slot
     *
     * @param slot   The slot to extract from
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The extracted {@link class_31}, <code>null</code> if nothing is extracted
     */
    public abstract class_31 extractItem(int slot, int amount);

    /**
     * Extract the given {@link class_124} with any meta from any slot
     *
     * @param item   The Item to extract
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The extracted ItemStack, <code>null</code> if nothing is extracted
     */
    public abstract class_31 extractItem(class_124 item, int amount);

    /**
     * Extract the given {@link class_124} with the specified meta from any slot
     *
     * @param item   The Item to extract
     * @param meta   The meta of the item to extract (-1 to match any meta)
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The extracted ItemStack, <code>null</code> if nothing is extracted
     */
    public abstract class_31 extractItem(class_124 item, int meta, int amount);

    /**
     * Check if the item supports inserting items, if this returns false there
     * should be no point in trying to use any <code>insertItem</code> method.
     *
     * @return <code>true</code> if the item supports item insertion
     */
    public abstract boolean canInsertItem();

    /**
     * Insert item into the given slot and return the remainder
     *
     * @param stack The {@link class_31} to insert
     * @param slot  Slot to insert into
     * @return The remainder of the ItemStack (<code>null</code> if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    public abstract class_31 insertItem(class_31 stack, int slot);

    /**
     * Insert item into any slot and return the remainder
     *
     * @param stack The {@link class_31} to insert
     * @return The remainder of the ItemStack (<code>null</code> if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    public abstract class_31 insertItem(class_31 stack);

    /**
     * Get the {@link class_31} in the given slot, If there is no {@link class_31}, then return null
     * <p>
     * <bold>DO NOT MODIFY THIS ITEMSTACK</bold>
     *
     * @param slot The slot to get the {@link class_31} from
     * @return The {@link class_31} in the slot, <code>null</code> if the slot is empty
     */
    public abstract class_31 getItem(int slot);

    /**
     * Directly sets the given slot to the given ItemStack
     *
     * @param stack The {@link class_31} to set the slot to
     * @param slot  The slot to put the stack into
     * @return Whether the action was succesfull
     */
    public abstract boolean setItem(class_31 stack, int slot);

    /**
     * Get the size of the item's inventory
     *
     * @return The number of slots this item's inventory has
     */
    public abstract int getItemSlots();

    /**
     * Get the entire inventory of the item
     *
     * @return An array of all the ItemStacks
     */
    public abstract class_31[] getInventory();
}
