package net.danygames2014.nyalib.mixin.item;

import net.danygames2014.nyalib.item.ItemHandler;
import net.minecraft.class_17;
import net.minecraft.class_225;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@SuppressWarnings({"AddedMixinMembersNamePattern", "DuplicatedCode"})
@Mixin(class_225.class)
public abstract class ChestBlockEntityMixin extends class_55 implements ItemHandler {

    @Shadow
    public abstract class_31 getStack(int slot);

    @Shadow
    public abstract class_31 removeStack(int slot, int amount);

    @Shadow
    public abstract int size();

    @Shadow
    public abstract void setStack(int slot, class_31 stack);


    // API Methods

    @Shadow private class_31[] inventory;

    @Override
    public boolean canExtractItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction side) {
        if (slot > 26 && isDoubleChest()) {
            return getSecondChest().method_949((slot - 27), amount);
        }

        return this.removeStack(slot, amount);
    }

    @Override
    public boolean canInsertItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction side) {
        class_31 slotStack;

        if (slot > 26 && isDoubleChest()) {
            slotStack = getSecondChest().method_954(slot - 27);
        } else {
            slotStack = this.getStack(slot);
        }


        if (slotStack == null) {
            if (slot > 26 && isDoubleChest()) {
                getSecondChest().method_950(slot - 27, stack);
            } else {
                this.setStack(slot, stack);
            }
            return null;
        }

        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);

            slotStack.field_751 += addedCount;

            if (addedCount >= stack.field_751) {
                return null;
            } else {
                return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction side) {
        class_31 insertedStack = stack.method_724();

        for (int i = 0; i < this.getItemSlots(side); ++i) {
            insertedStack = insertItem(insertedStack, i, side);
            if (insertedStack == null) {
                return insertedStack;
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItem(int slot, @Nullable Direction side) {
        if (slot > 26 && isDoubleChest()) {
            return getSecondChest().method_954(slot - 27);
        }

        return this.getStack(slot);
    }

    @Override
    public int getItemSlots(Direction side) {
        if (isDoubleChest()) {
            return this.size() + getSecondChest().method_948();
        }

        return this.size();
    }

    @Override
    public class_31[] getInventory(@Nullable Direction side) {
        return this.inventory;
    }

    // Double Chest Helper Methods
    @Unique
    public class_225 getSecondChest() {
        class_339 chestPos = null;

        // Find the chest
        if (isChestAtPos(field_1239 + 1, field_1240, field_1241)) {
            chestPos = new class_339(field_1239 + 1, field_1240, field_1241);
        }

        if (isChestAtPos(field_1239 - 1, field_1240, field_1241)) {
            chestPos = new class_339(field_1239 - 1, field_1240, field_1241);
        }

        if (isChestAtPos(field_1239, field_1240, field_1241 + 1)) {
            chestPos = new class_339(field_1239, field_1240, field_1241 + 1);
        }

        if (isChestAtPos(field_1239, field_1240, field_1241 - 1)) {
            chestPos = new class_339(field_1239, field_1240, field_1241 - 1);
        }

        // If no chest return null
        if (chestPos == null) {
            return null;
        }

        // Return the Item Handler for second chest
        if (field_1238.method_1777(chestPos.field_2100, chestPos.field_2101, chestPos.field_2102) instanceof class_225 chestEntity) {
            return chestEntity;
        }

        return null;
    }

    @Unique
    public boolean isDoubleChest() {
        return isChestAtPos(field_1239 + 1, field_1240, field_1241) || isChestAtPos(field_1239 - 1, field_1240, field_1241) || isChestAtPos(field_1239, field_1240, field_1241 + 1) || isChestAtPos(field_1239, field_1240, field_1241 - 1);
    }

    @Unique
    public boolean isChestAtPos(int x, int y, int z) {
        return field_1238.method_1776(x, y, z) == class_17.field_1895.field_1915;
    }

    @Override
    public boolean canConnectItem(Direction side) {
        return true;
    }
}
