package net.danygames2014.nyalib.mixin.item;

import net.danygames2014.nyalib.item.ItemHandler;
import net.minecraft.class_137;
import net.minecraft.class_31;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@SuppressWarnings({"AddedMixinMembersNamePattern", "DuplicatedCode"})
@Mixin(class_137.class)
public abstract class DispenserBlockEntityMixin extends class_55 implements ItemHandler {
    @Shadow
    public abstract class_31 removeStack(int slot, int amount);

    @Shadow
    public abstract class_31 getStack(int slot);

    @Shadow
    public abstract void setStack(int slot, class_31 stack);

    @Shadow
    public abstract int size();

    @Shadow private class_31[] inventory;

    @Override
    public boolean canExtractItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction side) {
        return this.removeStack(slot, amount);
    }

    @Override
    public boolean canInsertItem(@Nullable Direction side) {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction side) {
        class_31 slotStack;

        slotStack = this.getStack(slot);

        if (slotStack == null) {
            this.setStack(slot, stack);
            return null;
        }

        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);

            slotStack.field_751 += addedCount;

            if (addedCount >= stack.field_751) {
                return null;
            } else {
                return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction side) {
        class_31 insertedStack = stack.method_724();

        for (int i = 0; i < this.getItemSlots(side); ++i) {
            insertedStack = insertItem(insertedStack, i, side);
            if (insertedStack == null) {
                return insertedStack;
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItem(int slot, @Nullable Direction side) {
        return this.getStack(slot);
    }

    @Override
    public class_31[] getInventory(@Nullable Direction side) {
        return this.inventory;
    }

    @Override
    public int getItemSlots(Direction side) {
        return this.size();
    }

    @Override
    public boolean canConnectItem(Direction side) {
        return true;
    }
}
