package net.danygames2014.tropicraft.block;

import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_334;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class FruitTreeLeavesBlock extends TemplateBlock {
    public static final EnumProperty<FruitTreeVariant> VARIANT = EnumProperty.of("variant", FruitTreeVariant.class);
    public static final BooleanProperty HAS_FRUIT = BooleanProperty.of("has_fruit");

    public FruitTreeLeavesBlock(Identifier identifier) {
        super(identifier, class_15.field_987);
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(VARIANT);
        builder.add(HAS_FRUIT);
    }

    @Override
    public int method_1589(int meta) {
        return class_334.method_1083();
    }

    @Override
    public int method_1600(class_14 blockView, int x, int y, int z) {
        blockView.method_1781().method_1788(x, z, 1, 1);
        return class_334.method_1080(blockView.method_1781().field_2235[0], blockView.method_1781().field_2236[0]);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return getDefaultState().with(VARIANT, FruitTreeVariant.GENERIC).with(HAS_FRUIT, false);
    }

    @Override
    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        BlockState state = world.getBlockState(x, y, z);

        if (player.method_1373()) {
            world.setBlockStateWithNotify(x,y,z,state.cycle(VARIANT));
        } else {
            world.setBlockStateWithNotify(x,y,z,state.cycle(HAS_FRUIT));
        }

        return true;
    }

    @Override
    public boolean method_1620() {
        return false;
    }

    @Override
    public boolean method_1623() {
        return true;
    }
}
