package net.danygames2014.tropicraft.block;

import net.danygames2014.tropicraft.Tropicraft;
import net.danygames2014.tropicraft.world.ChunkDecorationListener;
import net.minecraft.class_15;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

import java.util.Random;

public class PalmSaplingBlock extends TemplateBlock {
    public PalmSaplingBlock(Identifier identifier, class_15 material) {
        super(identifier, material);
        this.method_1584(true);
    }

    @Override
    public boolean onBonemealUse(class_18 world, int x, int y, int z, BlockState state) {
        return generateTree(world, world.field_214, x, y, z);
    }

    @Override
    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        generateTree(world, random, x, y, z);
    }

    public boolean generateTree(class_18 world, Random random, int x, int y, int z) {
        if (world.field_180) {
            return false;
        }

        if (world.getBlockState(x, y - 1, z).isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("palm_grows_on")))) {
            switch (random.nextInt(6)) {
                case 0, 1, 2 -> {
                    return ChunkDecorationListener.smallPalmTreeFeature.generate(world, random, x, y, z, true);
                }
                case 3, 4 -> {
                    return ChunkDecorationListener.curvedPalmTreeFeature.generate(world, random, x, y, z, true);
                }
                case 5 -> {
                    return ChunkDecorationListener.tallPalmTreeFeature.generate(world, random, x, y, z, true);
                }
            }
        }
        return false;
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }
}
