package net.danygames2014.tropicraft.block;

import net.danygames2014.tropicraft.Tropicraft;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_352;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.StringIdentifiable;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PineappleBlock extends TemplateBlock {

    public static boolean chopped;

    public static final EnumProperty<PineappleHalf> PINEAPPLE_HALF = EnumProperty.of("half", PineappleHalf.class);

    public PineappleBlock(Identifier identifier) {
        super(identifier, class_15.field_988);
        this.method_1584(true);
        this.method_1578(0.2F, 0.0f, 0.2F, 0.8F, 1.0f, 0.8F);
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(PINEAPPLE_HALF);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        if (context.getWorld().getBlockState(context.getBlockPos().down()).isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("chopping_blocks")))) {
            return getDefaultState().with(PINEAPPLE_HALF, PineappleHalf.TOP);
        }

        return getDefaultState().with(PINEAPPLE_HALF, PineappleHalf.BOTTOM);
    }

    @Override
    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        if (world.getBlockState(x, y, z).get(PINEAPPLE_HALF) == PineappleHalf.BOTTOM && random.nextInt(50) == 0) {
            if (world.getBlockState(x, y + 1, z).isAir()) {
                world.setBlockState(x, y + 1, z, this.getDefaultState().with(PINEAPPLE_HALF, PineappleHalf.TOP));
            }
        }
    }

    @Override
    public boolean method_1561(class_18 world, int x, int y, int z, int side) {
        BlockState stateBelow = world.getBlockState(x, y - 1, z);
        return stateBelow.isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("can_place_pineapple_on"))) || stateBelow.isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("chopping_blocks")));
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        this.checkValidPlacement(world, x, y, z);
    }

    protected final void checkValidPlacement(class_18 world, int x, int y, int z) {
        if (world.getBlockState(x, y - 1, z).isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("chopping_blocks")))) {
            return;
        }

        if (!this.method_1566(world, x, y, z)) {
            if (world.getBlockState(x, y, z).get(PINEAPPLE_HALF) == PineappleHalf.TOP) {
                this.method_1581(world, x, y, z, new class_31(Tropicraft.pineapple.asItem(), 1, 0));
            }
            world.method_229(x, y, z, 0);
        }
    }

    @Override
    public boolean method_1566(class_18 world, int x, int y, int z) {
        return world.getBlockState(x, y - 1, z).isIn(TagKey.of(BlockRegistry.INSTANCE.getKey(), Tropicraft.NAMESPACE.id("pineapple_grows_on")));
    }

    @Override
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return null;
    }

    @Override
    public void method_1610(class_18 world, int x, int y, int z, class_54 player) {
        if (!world.field_180 && (player.field_519.method_675() != null) && (player.field_519.method_675().method_694() instanceof class_352)) {
            chop(world, x, y, z);
        }
    }

    public void chop(class_18 world, int x, int y, int z) {
        chopped = true;
        this.method_1592(world, x, y, z, 1);
        world.method_229(x, y, z, 0);
        chopped = false;
    }

    @Override
    public List<class_31> getDropList(class_18 world, int x, int y, int z, BlockState state, int meta) {
        ArrayList<class_31> drops = new ArrayList<>();

        // TODO: Remove this temporary patch when https://github.com/ModificationStation/StationAPI/issues/210 is fixed
        if(state.isAir()) {
            if (chopped) {
                drops.add(new class_31(Tropicraft.pineappleCubes, getRandomCubeCount(world.field_214)));
            } else {
                drops.add(new class_31(this, 1));
            }
            return drops;
        }
        
        if (state.get(PINEAPPLE_HALF) == PineappleHalf.TOP) {
            if (chopped) {
                drops.add(new class_31(Tropicraft.pineappleCubes, getRandomCubeCount(world.field_214)));
            } else {
                drops.add(new class_31(this, 1));
            }
        }

        return drops;
    }

    public int getRandomCubeCount(Random random) {
        if (chopped) {
            if (random.nextInt(7) == 0) {
                return 1;
            }
            if (random.nextInt(6) == 0) {
                return 2;
            }
            if (random.nextInt(5) == 0) {
                return 3;
            }
            return random.nextInt(4) == 0 ? 4 : 5;
        }
        return 1;
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }

    public enum PineappleHalf implements StringIdentifiable {
        TOP("top"),
        BOTTOM("bottom");

        final String pineappleHalf;

        PineappleHalf(String pineappleHalf) {
            this.pineappleHalf = pineappleHalf;
        }

        @Override
        public String asString() {
            return this.pineappleHalf;
        }
    }
}
